/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.JavaExecutionService;
import com.couchbase.lite.internal.NativeLibrary;
import com.couchbase.lite.internal.core.C4;
import com.couchbase.lite.internal.exec.ExecutionService;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.logging.LogSinksImpl;
import com.couchbase.lite.internal.utils.FileUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class CouchbaseLiteInternal {
    public static final String PLATFORM = "CBL-JAVA";
    public static final String SCRATCH_DIR_NAME = "CouchbaseLiteTemp";
    private static final String ERRORS_PROPERTIES_PATH = "/errors.properties";
    private static final AtomicReference<ExecutionService> EXECUTION_SERVICE = new AtomicReference();
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    @NonNull
    static final Object LOCK = new Object();
    private static volatile boolean debugging;
    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
    @NonNull
    private static volatile File defaultDbDir;
    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
    @NonNull
    private static volatile File scratchDir;

    private CouchbaseLiteInternal() {
    }

    public static void init(boolean debug, @NonNull File defaultDbDir, @NonNull File tempDir) {
        File tmpDir;
        if (INITIALIZED.getAndSet(true)) {
            return;
        }
        debugging = debug;
        CouchbaseLiteInternal.defaultDbDir = FileUtils.verifyDir(defaultDbDir);
        scratchDir = tmpDir = FileUtils.verifyDir(tempDir);
        NativeLibrary.load(tmpDir);
        C4.debug(debugging);
        LogSinksImpl.initLogging();
        CouchbaseLiteInternal.setC4TmpDirPath(tmpDir);
    }

    public static boolean debugging() {
        return debugging;
    }

    @NonNull
    public static ExecutionService getExecutionService() {
        ExecutionService executionService = EXECUTION_SERVICE.get();
        if (executionService != null) {
            return executionService;
        }
        EXECUTION_SERVICE.compareAndSet(null, new JavaExecutionService());
        return EXECUTION_SERVICE.get();
    }

    public static void requireInit(String message) {
        if (!INITIALIZED.get()) {
            throw new CouchbaseLiteError(message + ".  Did you forget to call CouchbaseLite.init()?");
        }
    }

    @NonNull
    public static File getDefaultDbDir() {
        CouchbaseLiteInternal.requireInit("Can't get default database directory");
        return defaultDbDir;
    }

    @NonNull
    public static String getDefaultDbDirPath() {
        CouchbaseLiteInternal.requireInit("Can't get default database directory");
        return defaultDbDir.getAbsolutePath();
    }

    @VisibleForTesting
    @NonNull
    public static File getScratchDir() {
        CouchbaseLiteInternal.requireInit("Can't get scratch directory");
        return scratchDir;
    }

    @VisibleForTesting
    @NonNull
    public static Map<String, String> loadErrorMessages() {
        Properties errors = new Properties();
        try (InputStream is = CouchbaseLiteInternal.class.getResourceAsStream(ERRORS_PROPERTIES_PATH);){
            errors.load(is);
        }
        catch (IOException e) {
            Log.i(LogDomain.DATABASE, "Failed to load error messages!", e);
        }
        return errors;
    }

    @VisibleForTesting
    public static void reset() {
        debugging = false;
        defaultDbDir = null;
        scratchDir = null;
        EXECUTION_SERVICE.set(null);
        INITIALIZED.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setC4TmpDirPath(@NonNull File scratchDir) {
        try {
            Object object = LOCK;
            synchronized (object) {
                C4.setTempDir(scratchDir.getAbsolutePath());
            }
        }
        catch (LiteCoreException e) {
            Log.w(LogDomain.DATABASE, "Failed to set c4TmpDir", e);
        }
    }
}

