/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.Collection;
import com.couchbase.lite.CollectionConfiguration;
import com.couchbase.lite.ConflictResolver;
import com.couchbase.lite.DocumentFlag;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.ReplicationFilter;
import com.couchbase.lite.internal.BaseCollection;
import com.couchbase.lite.internal.core.C4Constants;
import com.couchbase.lite.internal.core.peers.TaggedWeakPeerBinding;
import com.couchbase.lite.internal.exec.ClientTask;
import com.couchbase.lite.internal.fleece.FLDict;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.logging.Log;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ReplicationCollection
implements AutoCloseable {
    private static final LogDomain LOG_DOMAIN = LogDomain.REPLICATOR;
    @NonNull
    @VisibleForTesting
    static final TaggedWeakPeerBinding<ReplicationCollection> BOUND_COLLECTIONS = new TaggedWeakPeerBinding();
    public final long token;
    @NonNull
    public final String scope;
    @NonNull
    public final String name;
    @Nullable
    public final C4Filter c4PushFilter;
    @Nullable
    public final C4Filter c4PullFilter;
    @Nullable
    public final ConflictResolver resolver;
    @VisibleForTesting
    @Nullable
    final byte[] options;

    static boolean filterCallback(long collToken, @Nullable String scope, @Nullable String name, @Nullable String docID, @Nullable String revID, int flags, long body, boolean isPush) {
        C4Filter filter;
        ReplicationCollection coll = (ReplicationCollection)BOUND_COLLECTIONS.getBinding(collToken);
        Log.d(LOG_DOMAIN, "Running %s filter for doc %s@%s, %s@%s", isPush ? "push" : "pull", docID, revID, collToken, coll);
        if (coll == null) {
            Log.w(LOG_DOMAIN, "Request to filter unrecognized collection: " + scope + "." + name);
            return true;
        }
        C4Filter c4Filter = filter = isPush ? coll.c4PushFilter : coll.c4PullFilter;
        if (filter == null) {
            return true;
        }
        if (docID == null || revID == null) {
            Log.w(LOG_DOMAIN, "Ignoring filter request for null %s/%s", docID, revID);
            return true;
        }
        ClientTask<Boolean> task = new ClientTask<Boolean>(() -> filter.test(docID, revID, body, flags));
        task.execute();
        Exception err = task.getFailure();
        if (err != null) {
            Log.w(LOG_DOMAIN, "Replication filter failed", err);
            return false;
        }
        Boolean accepted = task.getResult();
        return accepted != null && accepted != false;
    }

    @NonNull
    public static ReplicationCollection[] createAll(@NonNull Set<Collection> collections) {
        ReplicationCollection[] replColls = new ReplicationCollection[collections.size()];
        int i = 0;
        for (Collection coll : collections) {
            replColls[i++] = ReplicationCollection.create(coll, null, null, null, null);
        }
        return replColls;
    }

    @NonNull
    public static ReplicationCollection[] createAll(@NonNull Map<Collection, CollectionConfiguration> collections) {
        ReplicationCollection[] replColls = new ReplicationCollection[collections.size()];
        int i = 0;
        for (Map.Entry<Collection, CollectionConfiguration> entry : collections.entrySet()) {
            replColls[i++] = ReplicationCollection.create(entry.getKey(), entry.getValue());
        }
        return replColls;
    }

    @NonNull
    public static ReplicationCollection create(@NonNull Collection coll, @NonNull CollectionConfiguration config) {
        List<String> channels;
        HashMap<String, Object> options = new HashMap<String, Object>();
        List<String> documentIDs = config.getDocumentIDs();
        if (documentIDs != null && !documentIDs.isEmpty()) {
            options.put("docIDs", documentIDs);
        }
        if ((channels = config.getChannels()) != null && !channels.isEmpty()) {
            options.put("channels", channels);
        }
        return ReplicationCollection.create(coll, options, config.getPushFilter(), config.getPullFilter(), config.getConflictResolver());
    }

    @NonNull
    public static ReplicationCollection create(@NonNull Collection coll, @Nullable Map<String, Object> options, @Nullable ReplicationFilter pushFilter, @Nullable ReplicationFilter pullFilter, @Nullable ConflictResolver resolver) {
        long token = BOUND_COLLECTIONS.reserveKey();
        ReplicationCollection replColl = new ReplicationCollection(token, coll.getScope().getName(), coll.getName(), options == null || options.isEmpty() ? null : FLEncoder.encodeMap(options), pushFilter == null ? null : new CollectionFilter(coll, pushFilter), pullFilter == null ? null : new CollectionFilter(coll, pullFilter), resolver);
        BOUND_COLLECTIONS.bind(token, replColl);
        return replColl;
    }

    @Nullable
    public static ReplicationCollection getBinding(long token) {
        return (ReplicationCollection)BOUND_COLLECTIONS.getBinding(token);
    }

    private ReplicationCollection(long token, @NonNull String scope, @NonNull String name, @Nullable byte[] options, @Nullable C4Filter pushFilter, @Nullable C4Filter pullFilter, @Nullable ConflictResolver resolver) {
        this.token = token;
        this.scope = scope;
        this.name = name;
        this.options = options;
        this.c4PushFilter = pushFilter;
        this.c4PullFilter = pullFilter;
        this.resolver = resolver;
    }

    @Nullable
    public ConflictResolver getConflictResolver() {
        return this.resolver;
    }

    @Override
    public void close() {
        BOUND_COLLECTIONS.unbind(this.token);
    }

    @NonNull
    public String toString() {
        return "ReplicationCollection{@" + Long.toHexString(this.token) + this.scope + "." + this.name + "(" + (this.c4PullFilter != null ? "<" : "") + (this.resolver != null ? "!" : "") + (this.c4PushFilter != null ? ">" : "") + ")}";
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @FunctionalInterface
    static interface C4Filter {
        public boolean test(@NonNull String var1, @NonNull String var2, long var3, int var5);
    }

    private static final class CollectionFilter
    implements C4Filter {
        @NonNull
        private final BaseCollection collection;
        @NonNull
        private final ReplicationFilter filter;

        CollectionFilter(@NonNull Collection collection, @NonNull ReplicationFilter filter) {
            this.collection = collection;
            this.filter = filter;
        }

        @Override
        public boolean test(@NonNull String docId, @NonNull String revId, long body, int flags) {
            return this.filter.filtered(this.collection.createFilterDocument(docId, revId, FLDict.create(body)), this.getDocumentFlags(flags));
        }

        @NonNull
        private EnumSet<DocumentFlag> getDocumentFlags(int flags) {
            EnumSet<DocumentFlag> fs = EnumSet.noneOf(DocumentFlag.class);
            if (C4Constants.hasFlags(flags, 1)) {
                fs.add(DocumentFlag.DELETED);
            }
            if (C4Constants.hasFlags(flags, 128)) {
                fs.add(DocumentFlag.ACCESS_REMOVED);
            }
            return fs;
        }
    }
}

