/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4BlobStore;
import com.couchbase.lite.internal.core.C4NativePeer;

public final class C4BlobReadStream
extends C4NativePeer {
    @NonNull
    private final C4BlobStore.NativeImpl impl;

    C4BlobReadStream(@NonNull C4BlobStore.NativeImpl impl, long peer) {
        super(peer);
        this.impl = impl;
    }

    public int read(byte[] b, int offset, long maxBytesToRead) throws LiteCoreException {
        return this.withPeerOrDefault(0, peer -> this.impl.nRead((long)peer, b, offset, maxBytesToRead));
    }

    public long getLength() throws LiteCoreException {
        return this.withPeerOrDefault(0L, this.impl::nGetLength);
    }

    public void seek(long position) throws LiteCoreException {
        this.withPeer(peer -> this.impl.nSeek((long)peer, position));
    }

    @Override
    public void close() {
        this.closePeer(null);
    }

    protected void finalize() throws Throwable {
        try {
            this.closePeer(LogDomain.DATABASE);
        }
        finally {
            super.finalize();
        }
    }

    private void closePeer(@Nullable LogDomain domain) {
        this.releasePeer(domain, peer -> {
            C4BlobStore.NativeImpl nativeImpl = this.impl;
            if (nativeImpl != null) {
                nativeImpl.nCloseReadStream((long)peer);
            }
        });
    }
}

