/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4BlobKey;
import com.couchbase.lite.internal.core.C4BlobStore;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.utils.Preconditions;

public final class C4BlobWriteStream
extends C4NativePeer {
    @NonNull
    private final C4BlobStore.NativeImpl impl;

    C4BlobWriteStream(@NonNull C4BlobStore.NativeImpl impl, long peer) {
        super(peer);
        this.impl = impl;
    }

    public void write(@NonNull byte[] bytes) throws LiteCoreException {
        Preconditions.assertNotNull(bytes, "bytes");
        this.write(bytes, bytes.length);
    }

    public void write(@NonNull byte[] bytes, int len) throws LiteCoreException {
        Preconditions.assertNotNull(bytes, "bytes");
        if (len <= 0) {
            return;
        }
        this.withPeer(peer -> this.impl.nWrite((long)peer, bytes, len));
    }

    @NonNull
    public C4BlobKey computeBlobKey() throws LiteCoreException {
        return this.withPeerOrThrow(peer -> C4BlobKey.create(this.impl.nComputeBlobKey((long)peer)));
    }

    public void install() throws LiteCoreException {
        this.withPeer(this.impl::nInstall);
    }

    @Override
    public void close() {
        this.closePeer(null);
    }

    protected void finalize() throws Throwable {
        try {
            this.closePeer(LogDomain.DATABASE);
        }
        finally {
            super.finalize();
        }
    }

    private void closePeer(@Nullable LogDomain domain) {
        this.releasePeer(domain, peer -> {
            C4BlobStore.NativeImpl nativeImpl = this.impl;
            if (nativeImpl != null) {
                nativeImpl.nCloseWriteStream((long)peer);
            }
        });
    }
}

