/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.internal.core.C4CollectionDocObserver;
import com.couchbase.lite.internal.core.C4CollectionObserver;
import com.couchbase.lite.internal.core.C4Database;
import com.couchbase.lite.internal.core.C4Document;
import com.couchbase.lite.internal.core.C4DocumentObserver;
import com.couchbase.lite.internal.core.C4Index;
import com.couchbase.lite.internal.core.C4Peer;
import com.couchbase.lite.internal.core.impl.NativeC4Collection;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.utils.Preconditions;

public final class C4Collection
extends C4Peer {
    @NonNull
    private static final NativeImpl NATIVE_IMPL = new NativeC4Collection();
    @NonNull
    private final NativeImpl impl;
    @NonNull
    private final C4Database db;
    @NonNull
    private final String scope;
    @NonNull
    private final String name;

    @NonNull
    public static C4Collection create(@NonNull C4Database c4db, @NonNull String scope, @NonNull String collection) throws LiteCoreException {
        return C4Collection.create(NATIVE_IMPL, c4db, scope, collection);
    }

    @GuardedBy(value="dbLock")
    @Nullable
    public static C4Collection get(@NonNull C4Database c4db, @NonNull String scope, @NonNull String collection) throws LiteCoreException {
        return C4Collection.get(NATIVE_IMPL, c4db, scope, collection);
    }

    @NonNull
    public static C4Collection getDefault(@NonNull C4Database c4db) throws LiteCoreException {
        return C4Collection.getDefault(NATIVE_IMPL, c4db);
    }

    @VisibleForTesting
    @NonNull
    static C4Collection create(@NonNull NativeImpl impl, @NonNull C4Database c4db, @NonNull String scope, @NonNull String collection) throws LiteCoreException {
        return new C4Collection(impl, c4db.withPeerOrThrow(dbPeer -> impl.nCreateCollection((long)dbPeer, scope, collection)), c4db, scope, collection);
    }

    @VisibleForTesting
    @GuardedBy(value="dbLock")
    @Nullable
    static C4Collection get(@NonNull NativeImpl impl, @NonNull C4Database c4db, @NonNull String scope, @NonNull String collection) throws LiteCoreException {
        long c4collection = c4db.withPeerOrThrow(dbPeer -> impl.nGetCollection((long)dbPeer, scope, collection));
        return c4collection == 0L ? null : new C4Collection(impl, c4collection, c4db, scope, collection);
    }

    @VisibleForTesting
    @NonNull
    static C4Collection getDefault(@NonNull NativeImpl impl, @NonNull C4Database c4db) throws LiteCoreException {
        return new C4Collection(impl, c4db.withPeerOrThrow(impl::nGetDefaultCollection), c4db, "_default", "_default");
    }

    private C4Collection(@NonNull NativeImpl impl, long peer, @NonNull C4Database db, @NonNull String scope, @NonNull String name) {
        super(peer, impl::nFree);
        this.impl = impl;
        this.db = db;
        this.scope = scope;
        this.name = name;
    }

    @Override
    @NonNull
    public String toString() {
        return "C4Collection" + super.toString();
    }

    public boolean isValid() {
        return this.withPeerOrDefault(false, this.impl::nCollectionIsValid);
    }

    public long getDocumentCount() {
        return this.withPeerOrDefault(0L, this.impl::nGetDocumentCount);
    }

    @Nullable
    public C4Document getDocument(@NonNull String docId) throws LiteCoreException {
        return C4Document.get(this, Preconditions.assertNotNull(docId, "doc ID"));
    }

    @Nullable
    public C4Document getDocumentWithRevs(@NonNull String docId) throws LiteCoreException {
        return C4Document.getWithRevs(this, Preconditions.assertNotNull(docId, "doc ID"));
    }

    @NonNull
    public C4Document createDocument(@NonNull String docID, @Nullable FLSliceResult body, int flags) throws LiteCoreException {
        return C4Document.create(this, docID, body, flags);
    }

    public void setDocumentExpiration(@NonNull String docID, long timeStamp) throws LiteCoreException {
        this.voidWithPeerOrWarn(peer -> this.impl.nSetDocExpiration((long)peer, docID, timeStamp));
    }

    public long getDocumentExpiration(@NonNull String docID) throws LiteCoreException {
        return this.withPeerOrDefault(0L, peer -> this.impl.nGetDocExpiration((long)peer, docID));
    }

    public void purgeDocument(@NonNull String docID) throws LiteCoreException {
        this.voidWithPeerOrWarn(peer -> this.impl.nPurgeDoc((long)peer, docID));
    }

    @NonNull
    public C4CollectionObserver createCollectionObserver(@NonNull Runnable listener) throws LiteCoreException {
        return this.withPeerOrThrow(peer -> C4CollectionObserver.newObserver(peer, listener));
    }

    @NonNull
    public C4DocumentObserver createDocumentObserver(@NonNull String docID, @NonNull Runnable listener) throws LiteCoreException {
        return this.withPeerOrThrow(peer -> C4CollectionDocObserver.newObserver(peer, docID, listener));
    }

    public void createValueIndex(@NonNull String name, int queryLanguage, @NonNull String indexSpec, @Nullable String where) throws LiteCoreException {
        this.voidWithPeerOrWarn(peer -> this.impl.nCreateValueIndex((long)peer, name, queryLanguage, indexSpec, where));
    }

    public void createArrayIndex(@NonNull String name, @NonNull String path, @NonNull String indexSpec) throws LiteCoreException {
        this.voidWithPeerOrWarn(peer -> this.impl.nCreateArrayIndex((long)peer, name, path, indexSpec));
    }

    public void createFullTextIndex(@NonNull String name, int queryLanguage, @NonNull String indexSpec, @Nullable String language, boolean ignoreDiacritics, @Nullable String where) throws LiteCoreException {
        this.voidWithPeerOrWarn(peer -> this.impl.nCreateFullTextIndex((long)peer, name, queryLanguage, indexSpec, language, ignoreDiacritics, where));
    }

    public void createPredictiveIndex(String name, String indexSpec) throws LiteCoreException {
        this.voidWithPeerOrWarn(peer -> this.impl.nCreatePredictiveIndex((long)peer, name, indexSpec));
    }

    public void createVectorIndex(@NonNull String name, @NonNull String queryExpressions, long dimensions, int metric, long centroids, int encoding, long subquantizers, long bits, long minTrainingSize, long maxTrainingSize, long numProbes, boolean isLazy) throws LiteCoreException {
        this.voidWithPeerOrWarn(peer -> this.impl.nCreateVectorIndex((long)peer, name, queryExpressions, dimensions, metric, centroids, encoding, subquantizers, bits, minTrainingSize, maxTrainingSize, numProbes, isLazy));
    }

    @NonNull
    public FLValue getIndexesInfo() throws LiteCoreException {
        return this.withPeerOrThrow(peer -> FLValue.getFLValue(this.impl.nGetIndexesInfo((long)peer)));
    }

    @GuardedBy(value="Database.getDbLock()")
    @Nullable
    public C4Index getIndex(@NonNull String name) throws LiteCoreException {
        long idx = this.withPeerOrThrow(peer -> this.impl.nGetIndex((long)peer, name));
        return idx == 0L ? null : C4Index.create(idx);
    }

    public void deleteIndex(@NonNull String name) throws LiteCoreException {
        this.voidWithPeerOrWarn(peer -> this.impl.nDeleteIndex((long)peer, name));
    }

    @NonNull
    public C4Database getDb() {
        return this.db;
    }

    @NonNull
    public String getScope() {
        return this.scope;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public static interface NativeImpl {
        public long nCreateCollection(long var1, @NonNull String var3, @NonNull String var4) throws LiteCoreException;

        public long nGetCollection(long var1, @NonNull String var3, @NonNull String var4) throws LiteCoreException;

        public long nGetDefaultCollection(long var1) throws LiteCoreException;

        public boolean nCollectionIsValid(long var1);

        public long nGetDocumentCount(long var1);

        public void nFree(long var1);

        public long nGetDocExpiration(long var1, @NonNull String var3) throws LiteCoreException;

        public void nSetDocExpiration(long var1, @NonNull String var3, long var4) throws LiteCoreException;

        public void nPurgeDoc(long var1, @NonNull String var3) throws LiteCoreException;

        public long nGetIndexesInfo(long var1) throws LiteCoreException;

        public void nCreateValueIndex(long var1, @NonNull String var3, int var4, @NonNull String var5, @Nullable String var6) throws LiteCoreException;

        public void nCreateArrayIndex(long var1, @NonNull String var3, @NonNull String var4, @NonNull String var5) throws LiteCoreException;

        public void nCreateFullTextIndex(long var1, @NonNull String var3, int var4, @NonNull String var5, @Nullable String var6, boolean var7, @Nullable String var8) throws LiteCoreException;

        public void nCreatePredictiveIndex(long var1, @NonNull String var3, @NonNull String var4) throws LiteCoreException;

        public void nCreateVectorIndex(long var1, @NonNull String var3, @NonNull String var4, long var5, int var7, long var8, int var10, long var11, long var13, long var15, long var17, long var19, boolean var21) throws LiteCoreException;

        public long nGetIndex(long var1, @NonNull String var3) throws LiteCoreException;

        public void nDeleteIndex(long var1, @NonNull String var3) throws LiteCoreException;
    }
}

