/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4DocumentChange;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.core.impl.NativeC4CollectionObserver;
import com.couchbase.lite.internal.core.peers.TaggedWeakPeerBinding;
import com.couchbase.lite.internal.listener.ChangeNotifier;
import com.couchbase.lite.internal.logging.Log;
import java.util.Arrays;
import java.util.List;

public final class C4CollectionObserver
extends C4NativePeer
implements ChangeNotifier.C4ChangeProducer<C4DocumentChange> {
    @NonNull
    private static final NativeImpl NATIVE_IMPL = new NativeC4CollectionObserver();
    private static final TaggedWeakPeerBinding<C4CollectionObserver> BOUND_OBSERVERS = new TaggedWeakPeerBinding();
    @VisibleForTesting
    final long token;
    @NonNull
    private final Runnable listener;
    @NonNull
    private final NativeImpl impl;

    static void callback(long token) {
        Log.d(LogDomain.DATABASE, "C4CollectionObserver.callback @%x", token);
        C4CollectionObserver observer = (C4CollectionObserver)BOUND_OBSERVERS.getBinding(token);
        if (observer == null) {
            return;
        }
        observer.listener.run();
    }

    @NonNull
    static C4CollectionObserver newObserver(long c4Coll, @NonNull Runnable listener) throws LiteCoreException {
        return C4CollectionObserver.newObserver(NATIVE_IMPL, c4Coll, listener);
    }

    @VisibleForTesting
    @NonNull
    static C4CollectionObserver newObserver(@NonNull NativeImpl impl, long c4Coll, @NonNull Runnable listener) throws LiteCoreException {
        long token = BOUND_OBSERVERS.reserveKey();
        long peer = impl.nCreate(token, c4Coll);
        C4CollectionObserver observer = new C4CollectionObserver(impl, token, peer, listener);
        BOUND_OBSERVERS.bind(token, observer);
        return observer;
    }

    private C4CollectionObserver(@NonNull NativeImpl impl, long token, long peer, @NonNull Runnable listener) {
        super(peer);
        this.impl = impl;
        this.token = token;
        this.listener = listener;
    }

    @Override
    @Nullable
    public List<C4DocumentChange> getChanges(int maxChanges) {
        return this.nullableWithPeerOrThrow(peer -> {
            C4DocumentChange[] changes = this.impl.nGetChanges((long)peer, maxChanges);
            return changes.length <= 0 ? null : Arrays.asList(changes);
        });
    }

    @Override
    public void close() {
        this.closePeer(null);
    }

    protected void finalize() throws Throwable {
        try {
            this.closePeer(LogDomain.DATABASE);
        }
        finally {
            super.finalize();
        }
    }

    private void closePeer(@Nullable LogDomain domain) {
        this.releasePeer(domain, peer -> {
            BOUND_OBSERVERS.unbind(this.token);
            NativeImpl nativeImpl = this.impl;
            if (nativeImpl != null) {
                nativeImpl.nFree((long)peer);
            }
        });
    }

    public static interface NativeImpl {
        public long nCreate(long var1, long var3) throws LiteCoreException;

        @NonNull
        public C4DocumentChange[] nGetChanges(long var1, int var3);

        public void nFree(long var1);
    }
}

