/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.AbstractReplicator;
import com.couchbase.lite.Collection;
import com.couchbase.lite.CollectionConfiguration;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.MaintenanceType;
import com.couchbase.lite.ReplicatorType;
import com.couchbase.lite.internal.QueryLanguage;
import com.couchbase.lite.internal.SocketFactory;
import com.couchbase.lite.internal.core.C4BlobStore;
import com.couchbase.lite.internal.core.C4Collection;
import com.couchbase.lite.internal.core.C4Peer;
import com.couchbase.lite.internal.core.C4Query;
import com.couchbase.lite.internal.core.C4Replicator;
import com.couchbase.lite.internal.core.C4Socket;
import com.couchbase.lite.internal.core.impl.NativeC4Database;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.FLSharedKeys;
import com.couchbase.lite.internal.sockets.MessageFraming;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public abstract class C4Database
extends C4Peer {
    public static final boolean VERSION_VECTORS_ENABLED = false;
    @VisibleForTesting
    public static final String DB_EXTENSION = ".cblite2";
    @VisibleForTesting
    static final int DB_FLAGS = 1;
    @NonNull
    private static final NativeImpl NATIVE_IMPL = new NativeC4Database();
    @NonNull
    private static final Map<MaintenanceType, Integer> MAINTENANCE_TYPE_MAP;
    @NonNull
    private final NativeImpl impl;
    @NonNull
    private final String name;
    @NonNull
    final AtomicReference<File> dbFile = new AtomicReference();

    @NonNull
    public static C4Database getUnmanagedDatabase(long peer) {
        return new UnmanagedC4Database(NATIVE_IMPL, peer);
    }

    @NonNull
    public static C4Database getDatabase(@NonNull String parentDirPath, @NonNull String name, boolean isFullSync, boolean isMMapEnabled, int algorithm, @Nullable byte[] encryptionKey) throws LiteCoreException {
        int dbFlags = 1;
        if (isFullSync) {
            dbFlags |= 0x80;
        }
        if (!isMMapEnabled) {
            dbFlags |= 0x10;
        }
        return C4Database.getDatabase(NATIVE_IMPL, parentDirPath, name, dbFlags, algorithm, encryptionKey);
    }

    @VisibleForTesting
    @NonNull
    static C4Database getDatabase(@NonNull String parentDirPath, @NonNull String name, int flags) throws LiteCoreException {
        return C4Database.getDatabase(NATIVE_IMPL, parentDirPath, name, flags, 0, null);
    }

    @VisibleForTesting
    @NonNull
    static C4Database getDatabase(@NonNull NativeImpl impl, @NonNull String parentDirPath, @NonNull String name, int flags, int algorithm, @Nullable byte[] encryptionKey) throws LiteCoreException {
        boolean pathOk = false;
        try {
            File parentDir = new File(parentDirPath);
            parentDirPath = parentDir.getCanonicalPath();
            pathOk = parentDir.exists() && parentDir.isDirectory();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!pathOk) {
            throw new LiteCoreException(1, 21, "Parent directory does not exist or is not a directory: " + parentDirPath);
        }
        return new ManagedC4Database(impl, name, impl.nOpen(parentDirPath, name, flags, algorithm, encryptionKey));
    }

    public static void copyDb(@NonNull String sourcePath, @NonNull String parentDir, @NonNull String name, int algorithm, @Nullable byte[] encryptionKey) throws LiteCoreException {
        C4Database.copyDb(NATIVE_IMPL, sourcePath, parentDir, name, 1, algorithm, encryptionKey);
    }

    @VisibleForTesting
    static void copyDb(@NonNull String sourcePath, @NonNull String parentDir, @NonNull String name, int flags) throws LiteCoreException {
        C4Database.copyDb(NATIVE_IMPL, sourcePath, parentDir, name, flags, 0, null);
    }

    @VisibleForTesting
    static void copyDb(@NonNull NativeImpl impl, @NonNull String sourcePath, @NonNull String parentDir, @NonNull String name, int flags, int algorithm, @Nullable byte[] encryptionKey) throws LiteCoreException {
        if (sourcePath.charAt(sourcePath.length() - 1) != File.separatorChar) {
            sourcePath = sourcePath + File.separator;
        }
        if (parentDir.charAt(parentDir.length() - 1) != File.separatorChar) {
            parentDir = parentDir + File.separator;
        }
        impl.nCopy(sourcePath, parentDir, name, flags, algorithm, encryptionKey);
    }

    public static void deleteNamedDb(@NonNull String directory, @NonNull String name) throws LiteCoreException {
        NATIVE_IMPL.nDeleteNamed(name, directory);
    }

    @NonNull
    public static File getDatabaseFile(@NonNull File directory, @NonNull String name) {
        return new File(directory, name + DB_EXTENSION);
    }

    protected C4Database(@NonNull NativeImpl impl, @NonNull String name, long peer, @Nullable C4Peer.PeerCleaner cleaner) {
        super(peer, cleaner);
        this.name = name;
        this.impl = impl;
    }

    @Override
    @NonNull
    public String toString() {
        return this.name + "@" + super.toString();
    }

    @Override
    public void close() {
        super.close();
    }

    public void closeDb() throws LiteCoreException {
        this.voidWithPeerOrThrow(this.impl::nClose);
        this.close();
    }

    @Nullable
    public String getDbPath() {
        File file = this.getDbFile();
        return file == null ? null : file.getPath() + File.separator;
    }

    @Nullable
    public String getDbDirectory() {
        File file = this.getDbFile();
        return file == null ? null : file.getParent();
    }

    @Nullable
    public String getDbFileName() {
        File file = this.getDbFile();
        return file == null ? null : file.getName();
    }

    @Nullable
    public String getDbName() {
        String dbFileName = this.getDbFileName();
        if (dbFileName == null) {
            return null;
        }
        if (dbFileName.endsWith(DB_EXTENSION)) {
            dbFileName = dbFileName.substring(0, dbFileName.length() - DB_EXTENSION.length());
        }
        return dbFileName;
    }

    public void deleteDb() throws LiteCoreException {
        this.voidWithPeerOrThrow(this.impl::nDelete);
        this.close();
    }

    @NonNull
    public byte[] getPublicUUID() throws LiteCoreException {
        return this.withPeerOrThrow(this.impl::nGetPublicUUID);
    }

    @NonNull
    public C4BlobStore getBlobStore() throws LiteCoreException {
        return this.withPeerOrThrow(C4BlobStore::create);
    }

    public void beginTransaction() throws LiteCoreException {
        this.voidWithPeerOrThrow(this.impl::nBeginTransaction);
    }

    public void endTransaction(boolean commit) throws LiteCoreException {
        this.voidWithPeerOrThrow(peer -> this.impl.nEndTransaction((long)peer, commit));
    }

    public void rekey(int keyType, byte[] newKey) throws LiteCoreException {
        this.voidWithPeerOrThrow(peer -> this.impl.nRekey((long)peer, keyType, newKey));
    }

    public boolean performMaintenance(MaintenanceType type) throws LiteCoreException {
        Integer mTyp = MAINTENANCE_TYPE_MAP.get((Object)type);
        if (mTyp == null) {
            throw new IllegalArgumentException("Unknown maintenance type: " + (Object)((Object)type));
        }
        return this.withPeerOrThrow(peer -> this.impl.nMaintenance((long)peer, mTyp));
    }

    public void setCookie(@NonNull URI uri, @NonNull String setCookieHeader, boolean acceptParentDomain) throws LiteCoreException {
        String uriStr = uri.toString();
        this.voidWithPeerOrThrow(peer -> this.impl.nSetCookie((long)peer, uriStr, setCookieHeader, acceptParentDomain));
    }

    @Nullable
    public String getCookies(@NonNull URI uri) throws LiteCoreException {
        String uriStr = uri.toString();
        return this.withPeerOrNull(peer -> this.impl.nGetCookies((long)peer, uriStr));
    }

    @NonNull
    public FLEncoder getSharedFleeceEncoder() {
        return FLEncoder.getUnmanagedEncoder(this.withPeerOrThrow(this.impl::nGetSharedFleeceEncoder));
    }

    @NonNull
    public FLSharedKeys getFLSharedKeys() {
        return new FLSharedKeys(this.withPeerOrThrow(this.impl::nGetFLSharedKeys));
    }

    @NonNull
    public Set<String> getScopeNames() throws LiteCoreException {
        return this.withPeerOrThrow(this.impl::nGetScopeNames);
    }

    public boolean hasScope(@NonNull String scope) {
        return this.withPeerOrThrow(peer -> this.impl.nHasScope((long)peer, scope));
    }

    @NonNull
    public Set<String> getCollectionNames(@NonNull String scope) throws LiteCoreException {
        return this.withPeerOrThrow(peer -> this.impl.nGetCollectionNames((long)peer, scope));
    }

    @NonNull
    public C4Collection addCollection(@NonNull String scopeName, @NonNull String collectionName) throws LiteCoreException {
        return C4Collection.create(this, scopeName, collectionName);
    }

    @Nullable
    public C4Collection getCollection(@NonNull String scopeName, @NonNull String collectionName) throws LiteCoreException {
        return C4Collection.get(this, scopeName, collectionName);
    }

    @NonNull
    public final C4Collection getDefaultCollection() throws LiteCoreException {
        return C4Collection.getDefault(this);
    }

    public void deleteCollection(@NonNull String scopeName, @NonNull String collectionName) throws LiteCoreException {
        this.voidWithPeerOrThrow(peer -> this.impl.nDeleteCollection((long)peer, scopeName, collectionName));
    }

    @NonNull
    public C4Replicator createRemoteReplicator(@NonNull Map<Collection, CollectionConfiguration> collections, @Nullable String scheme, @Nullable String host, int port, @Nullable String path, @Nullable String remoteDbName, @NonNull MessageFraming framing, @NonNull ReplicatorType type, boolean continuous, @Nullable Map<String, Object> options, @NonNull C4Replicator.StatusListener statusListener, @NonNull C4Replicator.DocEndsListener docEndsListener, @NonNull AbstractReplicator replicator, @Nullable SocketFactory socketFactory) throws LiteCoreException {
        return this.withPeerOrThrow(peer -> C4Replicator.createRemoteReplicator(collections, peer, scheme, host, port, path, remoteDbName, framing, type, continuous, options, statusListener, docEndsListener, replicator, socketFactory));
    }

    @NonNull
    public C4Replicator createLocalReplicator(@NonNull Map<Collection, CollectionConfiguration> collections, @NonNull C4Database targetDb, @NonNull ReplicatorType type, boolean continuous, @Nullable Map<String, Object> options, @NonNull C4Replicator.StatusListener statusListener, @NonNull C4Replicator.DocEndsListener docEndsListener, @NonNull AbstractReplicator replicator) throws LiteCoreException {
        return this.withPeerOrThrow(peer -> C4Replicator.createLocalReplicator(collections, peer, targetDb, type, continuous, options, statusListener, docEndsListener, replicator));
    }

    @NonNull
    public C4Replicator createMessageEndpointReplicator(@NonNull Set<Collection> collections, @NonNull C4Socket c4Socket, @Nullable Map<String, Object> options, @NonNull C4Replicator.StatusListener statusListener) throws LiteCoreException {
        return this.withPeerOrThrow(peer -> C4Replicator.createMessageEndpointReplicator(collections, peer, c4Socket, options, statusListener));
    }

    @NonNull
    public C4Query createJsonQuery(@NonNull String expression) throws LiteCoreException {
        return C4Query.create(this, QueryLanguage.JSON, expression);
    }

    @NonNull
    public C4Query createN1qlQuery(@NonNull String expression) throws LiteCoreException {
        return C4Query.create(this, QueryLanguage.N1QL, expression);
    }

    @Nullable
    private File getDbFile() {
        File file = this.dbFile.get();
        if (file != null) {
            return file;
        }
        String path = this.withPeerOrNull(this.impl::nGetPath);
        if (path == null) {
            return null;
        }
        try {
            this.dbFile.compareAndSet(null, new File(path).getCanonicalFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.dbFile.get();
    }

    static {
        HashMap<MaintenanceType, Integer> m = new HashMap<MaintenanceType, Integer>();
        m.put(MaintenanceType.COMPACT, 0);
        m.put(MaintenanceType.REINDEX, 1);
        m.put(MaintenanceType.INTEGRITY_CHECK, 2);
        m.put(MaintenanceType.OPTIMIZE, 3);
        m.put(MaintenanceType.FULL_OPTIMIZE, 4);
        MAINTENANCE_TYPE_MAP = Collections.unmodifiableMap(m);
    }

    static final class UnmanagedC4Database
    extends C4Database {
        UnmanagedC4Database(@NonNull NativeImpl impl, long peer) {
            super(impl, "shell", peer, null);
        }
    }

    public static interface NativeImpl {
        public long nOpen(@NonNull String var1, @NonNull String var2, int var3, int var4, byte[] var5) throws LiteCoreException;

        public void nClose(long var1) throws LiteCoreException;

        public void nFree(long var1);

        @Nullable
        public String nGetPath(long var1);

        public void nCopy(String var1, String var2, String var3, int var4, int var5, byte[] var6) throws LiteCoreException;

        public void nDelete(long var1) throws LiteCoreException;

        public void nDeleteNamed(@NonNull String var1, @NonNull String var2) throws LiteCoreException;

        @NonNull
        public byte[] nGetPublicUUID(long var1) throws LiteCoreException;

        public void nBeginTransaction(long var1) throws LiteCoreException;

        public void nEndTransaction(long var1, boolean var3) throws LiteCoreException;

        public boolean nMaintenance(long var1, int var3) throws LiteCoreException;

        public void nRekey(long var1, int var3, byte[] var4) throws LiteCoreException;

        public void nSetCookie(long var1, String var3, String var4, boolean var5) throws LiteCoreException;

        @Nullable
        public String nGetCookies(long var1, @NonNull String var3) throws LiteCoreException;

        public long nGetSharedFleeceEncoder(long var1);

        public long nGetFLSharedKeys(long var1);

        @NonNull
        public Set<String> nGetScopeNames(long var1) throws LiteCoreException;

        public boolean nHasScope(long var1, @NonNull String var3);

        @NonNull
        public Set<String> nGetCollectionNames(long var1, @NonNull String var3) throws LiteCoreException;

        public void nDeleteCollection(long var1, @NonNull String var3, @NonNull String var4) throws LiteCoreException;
    }

    static final class ManagedC4Database
    extends C4Database {
        ManagedC4Database(@NonNull NativeImpl impl, @NonNull String name, long peer) {
            super(impl, name, peer, impl::nFree);
        }
    }
}

