/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4Collection;
import com.couchbase.lite.internal.core.C4Constants;
import com.couchbase.lite.internal.core.C4Peer;
import com.couchbase.lite.internal.core.impl.NativeC4Document;
import com.couchbase.lite.internal.fleece.FLDict;
import com.couchbase.lite.internal.fleece.FLSharedKeys;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import com.couchbase.lite.internal.logging.Log;
import java.util.List;

public final class C4Document
extends C4Peer {
    @NonNull
    private static final NativeImpl NATIVE_IMPL = new NativeC4Document();
    @NonNull
    private final NativeImpl impl;

    @NonNull
    static C4Document create(@NonNull C4Collection coll, @NonNull String docID, @Nullable FLSliceResult body, int flags) throws LiteCoreException {
        return coll.withPeerOrThrow(collPeer -> new C4Document(NATIVE_IMPL, NATIVE_IMPL.nCreateFromSlice((long)collPeer, docID, body == null ? 0L : body.getBase(), body == null ? 0L : body.getSize(), flags)));
    }

    @Nullable
    static C4Document get(@NonNull C4Collection coll, @NonNull String docID) throws LiteCoreException {
        long doc = coll.withPeerOrThrow(collPeer -> NATIVE_IMPL.nGetFromCollection((long)collPeer, docID, true, false));
        return doc == 0L ? null : new C4Document(NATIVE_IMPL, doc);
    }

    @Nullable
    static C4Document getWithRevs(@NonNull C4Collection coll, @NonNull String docID) throws LiteCoreException {
        long doc = coll.withPeerOrThrow(collPeer -> NATIVE_IMPL.nGetFromCollection((long)collPeer, docID, true, true));
        return doc == 0L ? null : new C4Document(NATIVE_IMPL, doc);
    }

    @VisibleForTesting
    @NonNull
    static C4Document getOrCreateDocument(@NonNull C4Collection coll, @NonNull String docID) throws LiteCoreException {
        long doc = coll.withPeerOrThrow(collPeer -> NATIVE_IMPL.nGetFromCollection((long)collPeer, docID, false, true));
        if (doc == 0L) {
            throw new LiteCoreException(1, 7, "Could not create document: " + docID);
        }
        return new C4Document(NATIVE_IMPL, doc);
    }

    public static boolean dictContainsBlobs(@NonNull FLSliceResult dict, @NonNull FLSharedKeys sk) {
        return NATIVE_IMPL.nDictContainsBlobs(dict.getBase(), dict.getSize(), sk.getHandle());
    }

    private C4Document(@NonNull NativeImpl impl, long peer) {
        super(peer, impl::nFree);
        this.impl = impl;
    }

    @VisibleForTesting
    C4Document(long peer) {
        this(NATIVE_IMPL, peer);
    }

    @Nullable
    public String getRevID() {
        return this.withPeerOrNull(this.impl::nGetRevID);
    }

    public long getSequence() {
        return this.withPeerOrDefault(0L, this.impl::nGetSequence);
    }

    public int getSelectedFlags() {
        return this.withPeerOrDefault(0, this.impl::nGetSelectedFlags);
    }

    @Nullable
    public String getSelectedRevID() {
        return this.withPeerOrNull(this.impl::nGetSelectedRevID);
    }

    @Nullable
    public String getRevisionHistory(@NonNull C4Collection coll, long maxRevs, @Nullable List<String> backToRevs) throws LiteCoreException {
        String[] backToRevsArray = backToRevs == null ? null : backToRevs.toArray(new String[0]);
        return coll.withPeerOrNull(collPeer -> this.withPeerOrNull(peer -> this.impl.nGetRevisionHistory((long)collPeer, (long)peer, maxRevs, backToRevsArray)));
    }

    public long getSelectedSequence() {
        return this.withPeerOrDefault(0L, this.impl::nGetSelectedSequence);
    }

    @Nullable
    public FLDict getSelectedBody2() {
        long value = this.withPeerOrThrow(this.impl::nGetSelectedBody2);
        return value == 0L ? null : FLDict.create(value);
    }

    public long getTimestamp() {
        return this.withPeerOrDefault(-1L, this.impl::nGetTimestamp);
    }

    public void selectNextLeafRevision(boolean includeDeleted, boolean withBody) throws LiteCoreException {
        this.voidWithPeerOrThrow(peer -> this.impl.nSelectNextLeafRevision((long)peer, includeDeleted, withBody));
    }

    public void resolveConflict(String winningRevID, String losingRevID, byte[] mergeBody, int mergedFlags) throws LiteCoreException {
        this.voidWithPeerOrThrow(peer -> this.impl.nResolveConflict((long)peer, winningRevID, losingRevID, mergeBody, mergedFlags));
    }

    @Nullable
    public C4Document update(@Nullable FLSliceResult body, int flags) throws LiteCoreException {
        long newDoc = this.withPeerOrDefault(0L, h -> this.impl.nUpdate((long)h, body == null ? 0L : body.getBase(), body == null ? 0L : body.getSize(), flags));
        return newDoc == 0L ? null : new C4Document(this.impl, newDoc);
    }

    public void save(int maxRevTreeDepth) throws LiteCoreException {
        this.voidWithPeerOrThrow(peer -> this.impl.nSave((long)peer, maxRevTreeDepth));
    }

    @Nullable
    public String bodyAsJSON(boolean canonical) throws LiteCoreException {
        return this.withPeerOrNull(h -> this.impl.nBodyAsJSON((long)h, canonical));
    }

    public boolean docExists() {
        return C4Constants.hasFlags(this.getFlags(), 4096);
    }

    public boolean isDocDeleted() {
        return C4Constants.hasFlags(this.getFlags(), 1);
    }

    public boolean isDocConflicted() {
        return C4Constants.hasFlags(this.getFlags(), 2);
    }

    public boolean hasDocAttachments() {
        return C4Constants.hasFlags(this.getFlags(), 4);
    }

    public boolean isRevDeleted() {
        return C4Constants.hasFlags(this.getSelectedFlags(), 1);
    }

    public boolean isRevConflicted() {
        return C4Constants.hasFlags(this.getSelectedFlags(), 32);
    }

    public boolean hasRevAttachments() {
        return C4Constants.hasFlags(this.getFlags(), 8);
    }

    @Override
    public void close() {
        Log.w(LogDomain.DATABASE, "Unsafe call to C4Document.close()", new Exception("Unsafe call at:"));
    }

    @Override
    @NonNull
    public String toString() {
        return "C4Document" + super.toString();
    }

    private int getFlags() {
        return this.withPeerOrDefault(0, this.impl::nGetFlags);
    }

    public static interface NativeImpl {
        public long nGetFromCollection(long var1, String var3, boolean var4, boolean var5) throws LiteCoreException;

        public long nCreateFromSlice(long var1, String var3, long var4, long var6, int var8) throws LiteCoreException;

        public int nGetFlags(long var1);

        @NonNull
        public String nGetRevID(long var1);

        public long nGetSequence(long var1);

        public int nGetSelectedFlags(long var1);

        @NonNull
        public String nGetSelectedRevID(long var1);

        @Nullable
        public String nGetRevisionHistory(long var1, long var3, long var5, @Nullable String[] var7) throws LiteCoreException;

        public long nGetTimestamp(long var1);

        public long nGetSelectedSequence(long var1);

        public long nGetSelectedBody2(long var1);

        public void nSelectNextLeafRevision(long var1, boolean var3, boolean var4) throws LiteCoreException;

        public void nResolveConflict(long var1, String var3, String var4, byte[] var5, int var6) throws LiteCoreException;

        public long nUpdate(long var1, long var3, long var5, int var7) throws LiteCoreException;

        public void nSave(long var1, int var3) throws LiteCoreException;

        @Nullable
        public String nBodyAsJSON(long var1, boolean var3) throws LiteCoreException;

        public void nFree(long var1);

        public boolean nDictContainsBlobs(long var1, long var3, long var5);
    }
}

