/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.core.impl.NativeC4DocumentObserver;
import com.couchbase.lite.internal.core.peers.TaggedWeakPeerBinding;
import com.couchbase.lite.internal.logging.Log;

public class C4DocumentObserver
extends C4NativePeer {
    @NonNull
    protected static final NativeImpl NATIVE_IMPL = new NativeC4DocumentObserver();
    protected static final TaggedWeakPeerBinding<C4DocumentObserver> BOUND_OBSERVERS = new TaggedWeakPeerBinding();
    @VisibleForTesting
    final long token;
    @NonNull
    private final Runnable listener;
    @NonNull
    private final NativeImpl impl;

    static void callback(long token, long seq, @Nullable String docId) {
        Log.d(LogDomain.DATABASE, "C4CollectionDocObserver.callback @0x%x: %s (5d)", token, docId, seq);
        C4DocumentObserver observer = (C4DocumentObserver)BOUND_OBSERVERS.getBinding(token);
        if (observer == null) {
            return;
        }
        observer.listener.run();
    }

    protected C4DocumentObserver(@NonNull NativeImpl impl, long token, long peer, @NonNull Runnable listener) {
        super(peer);
        this.impl = impl;
        this.token = token;
        this.listener = listener;
    }

    @Override
    public void close() {
        this.closePeer(null);
    }

    protected void finalize() throws Throwable {
        try {
            this.closePeer(LogDomain.DATABASE);
        }
        finally {
            super.finalize();
        }
    }

    private void closePeer(@Nullable LogDomain domain) {
        this.releasePeer(domain, peer -> {
            BOUND_OBSERVERS.unbind(this.token);
            NativeImpl nativeImpl = this.impl;
            if (nativeImpl != null) {
                nativeImpl.nFree((long)peer);
            }
        });
    }

    public static interface NativeImpl {
        public long nCreate(long var1, long var3, String var5) throws LiteCoreException;

        public void nFree(long var1);
    }
}

