/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4IndexUpdater;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.core.impl.NativeC4Index;

public final class C4Index
extends C4NativePeer {
    @NonNull
    private static final NativeImpl NATIVE_IMPL = new NativeC4Index();
    private final NativeImpl impl;

    @NonNull
    public static C4Index create(long peer) {
        return new C4Index(NATIVE_IMPL, peer);
    }

    @VisibleForTesting
    C4Index(@NonNull NativeImpl impl, long peer) {
        super(peer);
        this.impl = impl;
    }

    @GuardedBy(value="Database.lock")
    @Nullable
    public C4IndexUpdater beginUpdate(int limit) throws LiteCoreException {
        return this.nullableWithPeerOrThrow(peer -> {
            long updater = this.impl.nBeginUpdate((long)peer, limit);
            return updater == 0L ? null : C4IndexUpdater.create(updater);
        });
    }

    @Override
    public void close() {
        this.closePeer(null);
    }

    protected void finalize() throws Throwable {
        try {
            this.closePeer(LogDomain.DATABASE);
        }
        finally {
            super.finalize();
        }
    }

    private void closePeer(@Nullable LogDomain domain) {
        this.releasePeer(domain, peer -> {
            NativeImpl nativeImpl = this.impl;
            if (nativeImpl != null) {
                nativeImpl.nReleaseIndex((long)peer);
            }
        });
    }

    public static interface NativeImpl {
        public long nBeginUpdate(long var1, int var3) throws LiteCoreException;

        public void nReleaseIndex(long var1);
    }
}

