/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.internal.core.impl.NativeC4Log;
import com.couchbase.lite.internal.logging.LogSinksImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class C4Log {
    @NonNull
    private static final Map<Integer, LogLevel> LOG_LEVEL_FROM_C4;
    @NonNull
    private static final Map<LogLevel, Integer> LOG_LEVEL_TO_C4;
    @NonNull
    private static final Map<String, LogDomain> LOGGING_DOMAIN_FROM_C4;
    @NonNull
    private static final Map<LogDomain, Set<String>> LOGGING_DOMAIN_TO_C4;
    private static final Set<String> KNOWN_C4_LOGGING_DOMAINS;
    @NonNull
    private static final Map<LogDomain, String> LOGGING_DOMAIN_TO_CANONICAL_C4;
    private static final AtomicBoolean IN_CALLBACK;
    private static final AtomicReference<CallbackInstrumentation> CALLBACK_INSTRUMENTATION;
    @NonNull
    private final NativeImpl impl;

    public static void logCallback(@Nullable String c4Domain, int c4Level, @Nullable String message) {
        IN_CALLBACK.set(true);
        CallbackInstrumentation instrumentation = CALLBACK_INSTRUMENTATION.get();
        if (instrumentation != null) {
            instrumentation.onCallback(c4Domain, c4Level, message);
        }
        LogSinksImpl.logFromCore(C4Log.getLogLevelForC4Level(c4Level), C4Log.getLoggingDomainForC4Domain(c4Domain), message);
        IN_CALLBACK.set(false);
    }

    @NonNull
    public static C4Log create() {
        return new C4Log(new NativeC4Log());
    }

    @NonNull
    private static LogLevel getLogLevelForC4Level(int c4Level) {
        LogLevel level = LOG_LEVEL_FROM_C4.get(c4Level);
        return level != null ? level : LogLevel.INFO;
    }

    @NonNull
    private static LogDomain getLoggingDomainForC4Domain(@Nullable String c4Domain) {
        LogDomain domain = LOGGING_DOMAIN_FROM_C4.get(c4Domain);
        return domain != null ? domain : LogDomain.DATABASE;
    }

    private C4Log(@NonNull NativeImpl impl) {
        this.impl = impl;
    }

    public void logToCore(@NonNull LogDomain domain, @NonNull LogLevel level, @NonNull String message) {
        if (IN_CALLBACK.get()) {
            LogSinksImpl.logFailure("Recursive logging", null);
            return;
        }
        this.impl.nLog(this.getCanonicalC4DomainForLoggingDomain(domain), this.getC4LevelForLogLevel(level), message);
    }

    public void initFileLogging(String path, LogLevel level, int maxKept, long maxSize, boolean plainText, String header) {
        this.impl.nWriteToBinaryFile(path, this.getC4LevelForLogLevel(level), maxKept - 1, maxSize, plainText, header);
    }

    public void setFileLogLevel(@NonNull LogLevel newLevel) {
        this.impl.nSetBinaryFileLevel(this.getC4LevelForLogLevel(newLevel));
    }

    public void setCallbackLevel(@NonNull LogLevel newLevel) {
        this.impl.nSetCallbackLevel(this.getC4LevelForLogLevel(newLevel));
    }

    public void setLogFilter(@NonNull LogLevel fileLevel, @NonNull LogLevel platformLevel, @NonNull Set<LogDomain> platformDomains) {
        HashSet<String> fileDomains = new HashSet<String>(KNOWN_C4_LOGGING_DOMAINS);
        Set<String> domains = this.getC4DomainsForLoggingDomains(platformDomains);
        if (platformLevel.compareTo(fileLevel) < 0) {
            for (String domain : domains) {
                this.setLogLevel(domain, platformLevel);
            }
            fileDomains.removeAll(domains);
        }
        for (String domain : fileDomains) {
            this.setLogLevel(domain, fileLevel);
        }
    }

    @VisibleForTesting
    public void setLogLevel(@NonNull LogDomain domain, @NonNull LogLevel level) {
        this.setLogLevel(this.getCanonicalC4DomainForLoggingDomain(domain), this.getC4LevelForLogLevel(level));
    }

    @VisibleForTesting
    public void setCallbackInstrumentation(@Nullable CallbackInstrumentation instrumentation) {
        CALLBACK_INSTRUMENTATION.set(instrumentation);
    }

    private void setLogLevel(@NonNull String domain, @NonNull LogLevel level) {
        this.setLogLevel(domain, this.getC4LevelForLogLevel(level));
    }

    private void setLogLevel(@NonNull String domain, int level) {
        if (IN_CALLBACK.get()) {
            LogSinksImpl.logFailure("Log Level", null);
            return;
        }
        this.impl.nSetLevel(domain, level);
    }

    @NonNull
    private Set<String> getC4DomainsForLoggingDomains(@NonNull Set<LogDomain> domains) {
        HashSet<String> newC4Domains = new HashSet<String>();
        for (LogDomain domain : domains) {
            Set<String> c4Domains = LOGGING_DOMAIN_TO_C4.get((Object)domain);
            if (c4Domains == null) continue;
            newC4Domains.addAll(c4Domains);
        }
        return newC4Domains;
    }

    @NonNull
    private String getCanonicalC4DomainForLoggingDomain(@NonNull LogDomain domain) {
        String c4Domain = LOGGING_DOMAIN_TO_CANONICAL_C4.get((Object)domain);
        return c4Domain != null ? c4Domain : "DB";
    }

    private int getC4LevelForLogLevel(@NonNull LogLevel logLevel) {
        Integer c4level = LOG_LEVEL_TO_C4.get((Object)logLevel);
        return c4level != null ? c4level : 2;
    }

    static {
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        m.put(0, (Object)LogLevel.DEBUG);
        m.put(1, (Object)LogLevel.VERBOSE);
        m.put(2, (Object)LogLevel.INFO);
        m.put(3, (Object)LogLevel.WARNING);
        m.put(4, (Object)LogLevel.ERROR);
        LOG_LEVEL_FROM_C4 = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put((Object)LogLevel.DEBUG, 0);
        m.put((Object)LogLevel.VERBOSE, 1);
        m.put((Object)LogLevel.INFO, 2);
        m.put((Object)LogLevel.WARNING, 3);
        m.put((Object)LogLevel.ERROR, 4);
        LOG_LEVEL_TO_C4 = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put("", (Object)LogDomain.DATABASE);
        m.put("Actor", (Object)LogDomain.REPLICATOR);
        m.put("BLIP", (Object)LogDomain.NETWORK);
        m.put("BLIPMessages", (Object)LogDomain.NETWORK);
        m.put("Blob", (Object)LogDomain.DATABASE);
        m.put("Changes", (Object)LogDomain.DATABASE);
        m.put("DB", (Object)LogDomain.DATABASE);
        m.put("Enum", (Object)LogDomain.QUERY);
        m.put("Listener", (Object)LogDomain.LISTENER);
        m.put("Query", (Object)LogDomain.QUERY);
        m.put("SQL", (Object)LogDomain.DATABASE);
        m.put("Sync", (Object)LogDomain.REPLICATOR);
        m.put("SyncBusy", (Object)LogDomain.REPLICATOR);
        m.put("TLS", (Object)LogDomain.NETWORK);
        m.put("WS", (Object)LogDomain.NETWORK);
        m.put("Zip", (Object)LogDomain.NETWORK);
        LOGGING_DOMAIN_FROM_C4 = Collections.unmodifiableMap(m);
        HashSet s = new HashSet();
        HashMap<LogDomain, Set<String>> m2 = new HashMap<LogDomain, Set<String>>();
        for (Map.Entry<String, LogDomain> entry : LOGGING_DOMAIN_FROM_C4.entrySet()) {
            LogDomain domain = entry.getValue();
            HashSet<String> domains = (HashSet<String>)m2.get((Object)domain);
            if (domains == null) {
                domains = new HashSet<String>();
                m2.put(domain, domains);
            }
            domains.add(entry.getKey());
        }
        for (Map.Entry<String, LogDomain> entry : m2.entrySet()) {
            Set domains = (Set)((Object)entry.getValue());
            m2.put((LogDomain)((Object)entry.getKey()), Collections.unmodifiableSet(domains));
            s.addAll(domains);
        }
        LOGGING_DOMAIN_TO_C4 = Collections.unmodifiableMap(m2);
        KNOWN_C4_LOGGING_DOMAINS = Collections.unmodifiableSet(s);
        m = new HashMap();
        m.put((Object)LogDomain.DATABASE, "DB");
        m.put((Object)LogDomain.NETWORK, "WS");
        m.put((Object)LogDomain.REPLICATOR, "Sync");
        m.put((Object)LogDomain.QUERY, "Query");
        m.put((Object)LogDomain.LISTENER, "Listener");
        LOGGING_DOMAIN_TO_CANONICAL_C4 = Collections.unmodifiableMap(m);
        IN_CALLBACK = new AtomicBoolean(false);
        CALLBACK_INSTRUMENTATION = new AtomicReference<Object>(null);
    }

    @VisibleForTesting
    public static interface CallbackInstrumentation {
        public void onCallback(@Nullable String var1, int var2, @Nullable String var3);
    }

    public static interface NativeImpl {
        public void nLog(@NonNull String var1, int var2, @NonNull String var3);

        public void nSetLevel(@NonNull String var1, int var2);

        public void nSetCallbackLevel(int var1);

        public void nSetBinaryFileLevel(int var1);

        public void nWriteToBinaryFile(String var1, int var2, int var3, long var4, boolean var6, String var7);
    }
}

