/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;

public abstract class C4NativePeer
implements AutoCloseable {
    @GuardedBy(value="getPeerLock()")
    private final long peer;
    @GuardedBy(value="getPeerLock()")
    private volatile boolean open = true;
    private volatile Exception history;

    protected C4NativePeer(@Nullable Long peer) {
        this((long)Preconditions.assertNotNull(peer, "peer handle"));
    }

    protected C4NativePeer(long peer) {
        this.peer = Preconditions.assertNotZero(peer, "peer handle");
        this.updateHistory(peer, "Created at:");
    }

    @NonNull
    public String toString() {
        return "@x" + Long.toHexString(this.peer);
    }

    @NonNull
    protected final Object getPeerLock() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long getPeer() {
        Object object = this.getPeerLock();
        synchronized (object) {
            if (this.open) {
                return this.peer;
            }
        }
        this.logBadCall();
        throw new CouchbaseLiteError("Operation on closed peer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <E extends Exception> void withPeer(@NonNull Fn.ConsumerThrows<Long, E> fn) throws E {
        Object object = this.getPeerLock();
        synchronized (object) {
            if (this.open) {
                fn.accept(this.peer);
                return;
            }
        }
        this.logBadCall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final <R, E extends Exception> R withPeerOrNull(@NonNull Fn.NullableFunctionThrows<Long, R, E> fn) throws E {
        Object object = this.getPeerLock();
        synchronized (object) {
            if (this.open) {
                return fn.apply(this.peer);
            }
        }
        this.logBadCall();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected final <R, E extends Exception> R withPeerOrDefault(@NonNull R def, @NonNull Fn.NullableFunctionThrows<Long, R, E> fn) throws E {
        Object object = this.getPeerLock();
        synchronized (object) {
            if (this.open) {
                R val = fn.apply(this.peer);
                R r = val != null ? val : def;
                return r;
            }
        }
        this.logBadCall();
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <E extends Exception> void voidWithPeerOrThrow(@NonNull Fn.ConsumerThrows<Long, E> fn) throws E {
        Object object = this.getPeerLock();
        synchronized (object) {
            if (this.open) {
                fn.accept(this.peer);
                return;
            }
        }
        this.logBadCall();
        throw new CouchbaseLiteError("Closed peer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final <R, E extends Exception> R nullableWithPeerOrThrow(@NonNull Fn.NullableFunctionThrows<Long, R, E> fn) throws E {
        Object object = this.getPeerLock();
        synchronized (object) {
            if (this.open) {
                return fn.apply(this.peer);
            }
        }
        this.logBadCall();
        throw new CouchbaseLiteError("Closed peer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected final <R> R nonNullWithPeerOrThrow(@NonNull Fn.NonNullFunction<Long, R> fn) {
        Object object = this.getPeerLock();
        synchronized (object) {
            if (this.open) {
                return fn.apply(this.peer);
            }
        }
        this.logBadCall();
        throw new CouchbaseLiteError("Closed peer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected final <R, E extends Exception> R withPeerOrThrow(@NonNull Fn.NonNullFunctionThrows<Long, R, E> fn) throws E {
        Object object = this.getPeerLock();
        synchronized (object) {
            if (this.open) {
                return fn.apply(this.peer);
            }
        }
        this.logBadCall();
        throw new CouchbaseLiteError("Closed peer");
    }

    protected final <E extends Exception> void releasePeer(@Nullable LogDomain domain, @Nullable Fn.ConsumerThrows<Long, E> fn) throws E {
        long peer = this.releasePeer(fn);
        if (!CouchbaseLiteInternal.debugging()) {
            return;
        }
        if (domain == null) {
            if (peer == 0L) {
                this.logBadCall();
            }
        } else if (peer != 0L) {
            this.logCall(domain, "Expected this peer to have been closed previously");
        }
        this.updateHistory(peer, "Released at:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Exception> long releasePeer(@Nullable Fn.ConsumerThrows<Long, E> fn) throws E {
        Object object = this.getPeerLock();
        synchronized (object) {
            long peer = this.releasePeerLocked();
            if (peer != 0L && fn != null) {
                fn.accept(peer);
            }
            return peer;
        }
    }

    @GuardedBy(value="lock")
    private long releasePeerLocked() {
        boolean open = this.open;
        this.open = false;
        return !open ? 0L : this.peer;
    }

    private void updateHistory(long peer, @NonNull String msg) {
        if (peer == 0L || !CouchbaseLiteInternal.debugging()) {
            return;
        }
        this.history = new Exception(msg, this.history);
    }

    private void logBadCall() {
        this.logCall(LogDomain.DATABASE, "Operation on closed native peer");
    }

    private void logCall(@NonNull LogDomain domain, @NonNull String message) {
        if (!CouchbaseLiteInternal.debugging()) {
            return;
        }
        long peer = this.peer;
        Log.d(domain, "%s@0x%x: " + message, new Exception("At: ", this.history), this.getClass().getSimpleName(), peer);
    }
}

