/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import androidx.annotation.CallSuper;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.exec.CBLExecutor;
import com.couchbase.lite.internal.exec.Cleaner;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;

public abstract class C4Peer
implements AutoCloseable {
    @VisibleForTesting
    static final Cleaner CLEANER = new Cleaner("c4peer");
    @VisibleForTesting
    static final CBLExecutor CORE_CLEANER = new CBLExecutor("CoreCleaner", 3, 3, new LinkedBlockingQueue<Runnable>());
    @NonNull
    private final String name = this.getClass().getSimpleName() + ClassUtils.objId(this);
    @NonNull
    private final PeerHolder peerHolder;
    @NonNull
    final Cleaner.Cleanable cleaner;

    protected C4Peer(long peer, @Nullable PeerCleaner cleaner) {
        this(peer, cleaner, true);
    }

    protected C4Peer(long peer, @Nullable PeerCleaner cleaner, boolean refCounted) {
        Preconditions.assertNotZero(peer, "peer");
        this.peerHolder = refCounted ? new PeerHolder(this.name, peer, cleaner) : new UncountedPeerHolder(this.name, peer, cleaner);
        this.cleaner = CLEANER.register(this, this.peerHolder);
    }

    @NonNull
    public String toString() {
        return this.name;
    }

    @Override
    @CallSuper
    public void close() {
        this.cleaner.clean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <E extends Exception> void voidWithPeerOrWarn(@NonNull Fn.ConsumerThrows<Long, E> fn) throws E {
        Object object = this.getPeerLock();
        synchronized (object) {
            long peer = this.peerHolder.peer;
            if (peer != 0L) {
                fn.accept(peer);
                return;
            }
            this.peerHolder.logBadCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <E extends Exception> void voidWithPeerOrThrow(@NonNull Fn.ConsumerThrows<Long, E> fn) throws E {
        Object object = this.getPeerLock();
        synchronized (object) {
            long peer = this.peerHolder.peer;
            if (peer != 0L) {
                fn.accept(peer);
                return;
            }
        }
        this.peerHolder.logBadCall();
        throw new CouchbaseLiteError("Closed peer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final <R, E extends Exception> R withPeerOrNull(@NonNull Fn.NullableFunctionThrows<Long, R, E> fn) throws E {
        Object object = this.getPeerLock();
        synchronized (object) {
            long peer = this.peerHolder.peer;
            if (peer != 0L) {
                return fn.apply(peer);
            }
            this.peerHolder.logBadCall();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected final <R, E extends Exception> R withPeerOrDefault(@NonNull R def, @NonNull Fn.NullableFunctionThrows<Long, R, E> fn) throws E {
        Object object = this.getPeerLock();
        synchronized (object) {
            long peer = this.peerHolder.peer;
            if (peer != 0L) {
                R val = fn.apply(peer);
                R r = val != null ? val : def;
                return r;
            }
        }
        this.peerHolder.logBadCall();
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected final <R, E extends Exception> R withPeerOrThrow(@NonNull Fn.NonNullFunctionThrows<Long, R, E> fn) throws E {
        Object object = this.getPeerLock();
        synchronized (object) {
            long peer = this.peerHolder.peer;
            if (peer != 0L) {
                return fn.apply(peer);
            }
        }
        this.peerHolder.logBadCall();
        throw new IllegalStateException("Closed peer");
    }

    @NonNull
    protected final Object getPeerLock() {
        return this.peerHolder.getPeerLock();
    }

    public static interface PeerCleaner {
        public void dispose(long var1);
    }

    private static class PeerHolder
    implements Cleaner.Cleanable {
        @Nullable
        private final PeerCleaner cleaner;
        protected final long id;
        @GuardedBy(value="name")
        private long peer;
        @NonNull
        private final String name;
        private final long createdAt;
        @NonNull
        private final AtomicReference<Exception> lifecycle;

        PeerHolder(@NonNull String name, long peer, @Nullable PeerCleaner cleaner) {
            this.id = peer;
            this.cleaner = cleaner;
            this.peer = peer;
            this.name = name;
            this.createdAt = System.currentTimeMillis();
            this.lifecycle = new AtomicReference<Exception>(!CouchbaseLiteInternal.debugging() ? null : new Exception("Created at:"));
        }

        @Override
        @SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
        public final void clean(boolean finalizing) {
            Exception origin;
            PeerCleaner disposer = this.cleaner;
            if (disposer != null) {
                if (!finalizing) {
                    this.disposeRef(disposer);
                } else {
                    CORE_CLEANER.execute(() -> this.disposeRef(disposer));
                }
            }
            if ((origin = this.lifecycle.get()) == null) {
                return;
            }
            if (!finalizing) {
                this.lifecycle.set(new Exception("Closed at:", origin));
                return;
            }
            CORE_CLEANER.execute(() -> Log.d(LogDomain.DATABASE, "Peer %s not explicitly closed", this.createdAt, this.name));
        }

        @NonNull
        public String toString() {
            return "PeerHolder{" + Long.toHexString(this.peer) + " @" + this.createdAt + "}";
        }

        @NonNull
        Object getPeerLock() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void disposeRef(@NonNull PeerCleaner disposer) {
            long peerRef;
            Object lock;
            Object object = lock = this.getPeerLock();
            synchronized (object) {
                peerRef = this.peer;
                this.peer = 0L;
            }
            if (peerRef == 0L) {
                return;
            }
            disposer.dispose(peerRef);
        }

        private void logBadCall() {
            Log.w(LogDomain.DATABASE, "Operation on closed native peer", new Exception("Used at:", this.lifecycle.get()));
        }
    }

    private static class UncountedPeerHolder
    extends PeerHolder {
        UncountedPeerHolder(@NonNull String name, long peer, @Nullable PeerCleaner cleaner) {
            super(name, peer, cleaner);
        }

        public int hashCode() {
            return (int)this.id;
        }

        public boolean equals(@Nullable Object o) {
            return this == o || o instanceof PeerHolder && ((PeerHolder)o).id == this.id;
        }
    }
}

