/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.core.impl.NativeC4QueryEnumerator;
import com.couchbase.lite.internal.fleece.FLArray;
import com.couchbase.lite.internal.fleece.FLArrayIterator;
import com.couchbase.lite.internal.utils.Preconditions;

public final class C4QueryEnumerator
extends C4NativePeer {
    @NonNull
    private static final NativeImpl NATIVE_IMPL = new NativeC4QueryEnumerator();
    @NonNull
    private final NativeImpl impl;

    @NonNull
    static C4QueryEnumerator create(long peer) {
        return new C4QueryEnumerator(NATIVE_IMPL, Preconditions.assertNotZero(peer, "query enumerator peer"));
    }

    @VisibleForTesting
    C4QueryEnumerator(@NonNull NativeImpl impl, long peer) {
        super(peer);
        this.impl = impl;
    }

    public boolean next() throws LiteCoreException {
        return this.withPeerOrThrow(this.impl::nNext);
    }

    @NonNull
    public FLArrayIterator getColumns() {
        return this.withPeerOrThrow(peer -> FLArray.unmanagedIterator(this.impl.nGetColumns((long)peer)));
    }

    public long getMissingColumns() {
        return this.withPeerOrThrow(this.impl::nGetMissingColumns);
    }

    @Override
    public void close() {
        this.closePeer(null);
    }

    protected void finalize() throws Throwable {
        try {
            this.closePeer(LogDomain.QUERY);
        }
        finally {
            super.finalize();
        }
    }

    private void closePeer(@Nullable LogDomain domain) {
        this.releasePeer(domain, peer -> {
            NativeImpl nativeImpl = this.impl;
            if (nativeImpl != null) {
                nativeImpl.nFree((long)peer);
            }
        });
    }

    public static interface NativeImpl {
        public boolean nNext(long var1) throws LiteCoreException;

        public void nFree(long var1);

        public long nGetColumns(long var1);

        public long nGetMissingColumns(long var1);
    }
}

