/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.core.C4Query;
import com.couchbase.lite.internal.core.C4QueryEnumerator;
import com.couchbase.lite.internal.core.impl.NativeC4QueryObserver;
import com.couchbase.lite.internal.core.peers.TaggedWeakPeerBinding;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.Fn;
import javax.annotation.Nullable;

public final class C4QueryObserver
extends C4NativePeer {
    @VisibleForTesting
    @NonNull
    private static final NativeImpl NATIVE_IMPL = new NativeC4QueryObserver();
    @NonNull
    @VisibleForTesting
    static final TaggedWeakPeerBinding<C4QueryObserver> QUERY_OBSERVER_CONTEXT = new TaggedWeakPeerBinding();
    private final long token;
    @NonNull
    private final NativeImpl impl;
    @NonNull
    private final Fn.Function<Long, C4QueryEnumerator> c4QueryEnumeratorFactory;
    @NonNull
    private final QueryChangeCallback callback;

    @NonNull
    public static C4QueryObserver create(@NonNull C4Query query, @NonNull QueryChangeCallback callback) {
        return C4QueryObserver.create(NATIVE_IMPL, C4QueryEnumerator::create, query, callback);
    }

    @NonNull
    static C4QueryObserver create(@NonNull NativeImpl impl, @NonNull Fn.Function<Long, C4QueryEnumerator> queryEnumeratorFactory, @NonNull C4Query query, @NonNull QueryChangeCallback callback) {
        long token = QUERY_OBSERVER_CONTEXT.reserveKey();
        long peer = query.withPeerOrThrow(queryPeer -> impl.nCreate(token, (long)queryPeer));
        C4QueryObserver observer = new C4QueryObserver(impl, peer, queryEnumeratorFactory, token, callback);
        QUERY_OBSERVER_CONTEXT.bind(token, observer);
        return observer;
    }

    static void onQueryChanged(long token, long results, int domain, int code, @Nullable String message) {
        C4QueryObserver observer = (C4QueryObserver)QUERY_OBSERVER_CONTEXT.getBinding(token);
        if (observer == null) {
            Log.w(LogDomain.QUERY, "No observer for token: " + token);
            return;
        }
        observer.queryChanged(results, domain, code, message);
    }

    @VisibleForTesting
    C4QueryObserver(@NonNull NativeImpl impl, long peer, @NonNull Fn.Function<Long, C4QueryEnumerator> c4QueryEnumeratorFactory, long token, @NonNull QueryChangeCallback callback) {
        super(peer);
        this.impl = impl;
        this.c4QueryEnumeratorFactory = c4QueryEnumeratorFactory;
        this.token = token;
        this.callback = callback;
    }

    @Override
    public void close() {
        QUERY_OBSERVER_CONTEXT.unbind(this.token);
        this.closePeer(null);
    }

    @Override
    @NonNull
    public String toString() {
        return "C4QueryObserver{" + ClassUtils.objId(this) + "/" + super.toString() + ": " + this.token + "}";
    }

    public void enable() {
        this.impl.nEnable(this.getPeer());
    }

    protected void finalize() throws Throwable {
        try {
            this.closePeer(LogDomain.LISTENER);
        }
        finally {
            super.finalize();
        }
    }

    void queryChanged(long results, int domain, int code, @Nullable String message) {
        this.callback.onQueryChanged(results == 0L ? null : this.c4QueryEnumeratorFactory.apply(results), code == 0 ? null : new LiteCoreException(domain, code, message));
    }

    private void closePeer(@Nullable LogDomain domain) {
        this.releasePeer(domain, peer -> {
            NativeImpl nativeImpl = this.impl;
            if (nativeImpl != null) {
                nativeImpl.nFree((long)peer);
            }
        });
    }

    public static interface NativeImpl {
        public long nCreate(long var1, long var3);

        public void nEnable(long var1);

        public void nFree(long var1);
    }

    @FunctionalInterface
    public static interface QueryChangeCallback {
        public void onQueryChanged(@Nullable C4QueryEnumerator var1, @Nullable LiteCoreException var2);
    }
}

