/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core.peers;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.CouchbaseLiteError;
import java.util.Set;

abstract class PeerBinding<T> {
    PeerBinding() {
    }

    public final synchronized void bind(long key, @NonNull T obj) {
        this.preBind(key, obj);
        T currentBinding = this.get(key);
        if (currentBinding == obj) {
            return;
        }
        if (currentBinding == null) {
            this.set(key, obj);
            return;
        }
        throw new CouchbaseLiteError("Attempt to rebind peer @x" + Long.toHexString(key));
    }

    @Nullable
    public final synchronized T getBinding(long key) {
        this.preGetBinding(key);
        return this.get(key);
    }

    public final synchronized void unbind(long key) {
        this.remove(key);
    }

    @VisibleForTesting
    public abstract int size();

    @VisibleForTesting
    public abstract void clear();

    @VisibleForTesting
    @NonNull
    public abstract Set<Long> keySet();

    @GuardedBy(value="this")
    protected abstract void preBind(long var1, @NonNull T var3);

    @GuardedBy(value="this")
    protected abstract void preGetBinding(long var1);

    @GuardedBy(value="this")
    @Nullable
    protected abstract T get(long var1);

    @GuardedBy(value="this")
    protected abstract boolean exists(long var1);

    @GuardedBy(value="this")
    protected abstract void set(long var1, @Nullable T var3);

    @GuardedBy(value="this")
    protected abstract void remove(long var1);
}

