/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.exec;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.exec.InstrumentedTask;
import com.couchbase.lite.internal.logging.Log;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class CBLExecutor
extends ThreadPoolExecutor {
    public static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    public static final int POOL_SIZE = Math.max(4, CPU_COUNT - 1);
    @NonNull
    private final String name;
    @GuardedBy(value="name")
    private long n;
    @GuardedBy(value="name")
    private int qSizeMax;
    @GuardedBy(value="name")
    private float qSizeMean;
    @GuardedBy(value="name")
    private float qSizeVariance;
    @GuardedBy(value="name")
    private float m2;

    public CBLExecutor(@NonNull String name) {
        this(name, POOL_SIZE, POOL_SIZE, new LinkedBlockingQueue<Runnable>());
    }

    public CBLExecutor(@NonNull String name, int min, int max, @NonNull BlockingQueue<Runnable> workQueue) {
        this(name, min, max, 30L, workQueue);
    }

    public CBLExecutor(final @NonNull String name, int min, int max, long ttlSecs, @NonNull BlockingQueue<Runnable> queue) {
        super(min, max, ttlSecs, TimeUnit.SECONDS, queue, new ThreadFactory(){
            private final String threadName;
            private final AtomicInteger threadId;
            {
                this.threadName = name + " #";
                this.threadId = new AtomicInteger(0);
            }

            @Override
            @NonNull
            public Thread newThread(@NonNull Runnable r) {
                int id = this.threadId.incrementAndGet();
                Thread thread = new Thread(r, this.threadName + id);
                thread.setDaemon(true);
                thread.setUncaughtExceptionHandler((t, e) -> Log.e(LogDomain.DATABASE, "Uncaught exception on thread %s", e, thread.getName()));
                Log.i(LogDomain.DATABASE, "New thread: %s", thread.getName());
                return thread;
            }
        });
        this.allowCoreThreadTimeOut(true);
        this.name = name;
    }

    @Override
    public void execute(@NonNull Runnable task) {
        try {
            super.execute(task);
        }
        finally {
            this.computeQueueStats();
        }
    }

    @Override
    @NonNull
    public String toString() {
        return "CBLExecutor{" + this.name + "}";
    }

    public void dumpState() {
        Stats stats = this.getStats();
        Log.w(LogDomain.DATABASE, "==== CBL Executor \"%s\" (%s)", this.name, stats.isShutdown ? "x" : (stats.isTerminated ? "-" : (stats.isTerminating ? "o" : "+")));
        Log.w(LogDomain.DATABASE, "== Tasks: %d, %d", stats.totalTasks, stats.completedTasks);
        Log.w(LogDomain.DATABASE, "== Pool: %d, %d, %d, %d", stats.poolSize, stats.corePoolSize, stats.largestPoolSize, stats.maxPoolSize);
        Log.w(LogDomain.DATABASE, "== Queue: %d, %d, %.2f, %.4f", stats.qCurSize, stats.qMaxSize, Float.valueOf(stats.qMeanSize), stats.qSizeSD);
        ArrayList<Runnable> waiting = new ArrayList<Runnable>(this.getQueue());
        int n = 0;
        for (Runnable r : waiting) {
            Log.w(LogDomain.DATABASE, "@%d: %s", !(r instanceof InstrumentedTask) ? null : ((InstrumentedTask)r).origin, n++, r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Stats getStats() {
        double variance;
        float mean;
        int max;
        String string = this.name;
        synchronized (string) {
            max = this.qSizeMax;
            mean = this.qSizeMean;
            variance = this.qSizeVariance;
        }
        return new Stats(this.isShutdown(), this.isTerminating(), this.isTerminated(), this.getTaskCount(), this.getCompletedTaskCount(), this.getPoolSize(), this.getCorePoolSize(), this.getLargestPoolSize(), this.getMaximumPoolSize(), this.getQueue().size(), max, mean, Math.sqrt(variance));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeQueueStats() {
        int qSize = this.getQueue().size();
        String string = this.name;
        synchronized (string) {
            if (this.qSizeMax < qSize) {
                this.qSizeMax = qSize;
            }
            ++this.n;
            float delta = (float)qSize - this.qSizeMean;
            this.qSizeMean += delta / (float)this.n;
            this.m2 += delta * ((float)qSize - this.qSizeMean);
            if (this.n > 2L) {
                this.qSizeVariance = this.m2 / (float)(this.n - 1L);
            }
        }
    }

    public static class Stats {
        public final boolean isShutdown;
        public final boolean isTerminating;
        public final boolean isTerminated;
        public final long totalTasks;
        public final long completedTasks;
        public final int poolSize;
        public final int corePoolSize;
        public final int largestPoolSize;
        public final int maxPoolSize;
        public final int qCurSize;
        public final int qMaxSize;
        public final float qMeanSize;
        public final double qSizeSD;

        public Stats(boolean isShutdown, boolean isTerminating, boolean isTerminated, long totalTasks, long completedTasks, int poolSize, int corePoolSize, int largestPoolSize, int maxPoolSize, int qCurSize, int qMaxSize, float qMeanSize, double qSizeSD) {
            this.isShutdown = isShutdown;
            this.isTerminating = isTerminating;
            this.isTerminated = isTerminated;
            this.totalTasks = totalTasks;
            this.completedTasks = completedTasks;
            this.poolSize = poolSize;
            this.corePoolSize = corePoolSize;
            this.largestPoolSize = largestPoolSize;
            this.maxPoolSize = maxPoolSize;
            this.qCurSize = qCurSize;
            this.qMaxSize = qMaxSize;
            this.qMeanSize = qMeanSize;
            this.qSizeSD = qSizeSD;
        }
    }
}

