/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.exec;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.internal.exec.CleanerImpl;
import java.util.List;

public final class Cleaner {
    @NonNull
    private final CleanerImpl impl;

    public Cleaner(@NonNull String name) {
        this(name, 2000);
    }

    @VisibleForTesting
    Cleaner(@NonNull String name, int timeoutMs) {
        CleanerImpl impl = new CleanerImpl(name + "-cleaner", timeoutMs);
        impl.register(this, ignore -> impl.stopCleaner());
        this.impl = impl;
    }

    @NonNull
    public Cleanable register(@NonNull Object obj, @NonNull Cleanable cleaner) {
        return this.impl.register(obj, cleaner);
    }

    @VisibleForTesting
    void stop() {
        this.impl.stopCleaner();
    }

    @VisibleForTesting
    boolean isStopped() {
        return this.impl.isStopped();
    }

    @VisibleForTesting
    @NonNull
    public Stats getStats() {
        return this.impl.getStats();
    }

    @FunctionalInterface
    public static interface Cleanable {
        public void clean(boolean var1);
    }

    @VisibleForTesting
    public static class Stats {
        public final long timeIn;
        public final int minSize;
        public final int maxSize;
        public final List<Long> alive;

        public Stats(long timeIn, int minSize, int maxSize, @NonNull List<Long> alive) {
            this.timeIn = timeIn;
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.alive = alive;
        }
    }
}

