/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.exec;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.exec.Cleaner;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.Fn;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

class CleanerImpl {
    private static final LogDomain LOG = LogDomain.DATABASE;
    private final Object lock = new Object();
    @NonNull
    private final AtomicBoolean shouldStop = new AtomicBoolean();
    @GuardedBy(value="alive")
    @NonNull
    private final Set<CleanableRef> alive = new HashSet<CleanableRef>();
    @NonNull
    private final ReferenceQueue<Object> zombies = new ReferenceQueue();
    @GuardedBy(value="lock")
    @Nullable
    private CleanerThread cleanerThread;
    @GuardedBy(value="lock")
    private int threadId;
    private final int timeoutMs;
    @GuardedBy(value="alive")
    private int minSize;
    @GuardedBy(value="alive")
    private int maxSize;
    @NonNull
    private final String cleanerName;

    CleanerImpl(@NonNull String cleanerName, int timeoutMs) {
        this.cleanerName = cleanerName;
        this.timeoutMs = timeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    final Cleaner.Cleanable register(@NonNull Object obj, @NonNull Cleaner.Cleanable cleanable) {
        if (this.shouldStop.get()) {
            throw new CouchbaseLiteError("Attempt to register with a closed cleaner");
        }
        CleanableRef ref = new CleanableRef(obj, cleanable);
        Object object = this.alive;
        synchronized (object) {
            if (!this.alive.add(ref)) {
                throw new CouchbaseLiteError("Attempt to register a duplicate CleanableRef");
            }
            int curSize = this.alive.size();
            if (curSize > this.maxSize) {
                this.maxSize = curSize;
            }
        }
        object = this.lock;
        synchronized (object) {
            if (this.cleanerThread == null) {
                this.startCleaner();
            }
        }
        return ref;
    }

    @GuardedBy(value="lock")
    @VisibleForTesting
    final void startCleaner() {
        this.cleanerThread = new CleanerThread(this.cleanerName + "-thread-" + ++this.threadId);
        this.cleanerThread.start();
    }

    @VisibleForTesting
    @Nullable
    Cleaner.Cleanable getNextZombie() {
        try {
            return (Cleaner.Cleanable)((Object)this.zombies.remove(this.timeoutMs));
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    @VisibleForTesting
    final void stopCleaner() {
        this.shouldStop.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isStopped() {
        Object object = this.lock;
        synchronized (object) {
            return this.shouldStop.get() && this.cleanerThread == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NonNull
    final Cleaner.Stats getStats() {
        Set<CleanableRef> set = this.alive;
        synchronized (set) {
            int curSize;
            Cleaner.Stats stats = new Cleaner.Stats(this.cleanerThread == null ? 0L : this.cleanerThread.getRuntimeNanos(), this.minSize, this.maxSize, Fn.mapToList(this.alive, ref -> ((CleanableRef)ref).ts));
            this.minSize = curSize = this.alive.size();
            this.maxSize = curSize;
            return stats;
        }
    }

    private final class CleanerThread
    extends Thread {
        private final AtomicLong runtime;

        CleanerThread(String name) {
            super(name);
            this.runtime = new AtomicLong();
            this.setPriority(8);
            this.setDaemon(true);
        }

        @Override
        @NonNull
        public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
            return (t, e) -> {
                Log.w(LOG, "Cleaner thread %s-%s crashed", e, CleanerImpl.this.cleanerName, t.getName());
                Thread.UncaughtExceptionHandler hdlr = CleanerThread.getDefaultUncaughtExceptionHandler();
                if (hdlr != null) {
                    hdlr.uncaughtException(t, e);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object ref;
            Log.i(LOG, "Cleaner thread %s started", this.getName());
            Exception err = null;
            boolean stopping = CleanerImpl.this.shouldStop.get();
            try {
                while (!stopping) {
                    ref = CleanerImpl.this.getNextZombie();
                    stopping = CleanerImpl.this.shouldStop.get();
                    if (ref == null) continue;
                    long t = System.nanoTime();
                    ref.clean(true);
                    this.runtime.getAndAdd(System.nanoTime() - t);
                }
            }
            catch (Exception e) {
                try {
                    err = e;
                }
                catch (Throwable throwable) {
                    Object object = CleanerImpl.this.lock;
                    synchronized (object) {
                        if (this.equals(CleanerImpl.this.cleanerThread)) {
                            if (stopping) {
                                CleanerImpl.this.cleanerThread = null;
                            } else {
                                CleanerImpl.this.startCleaner();
                            }
                        }
                    }
                    Log.w(LOG, "Cleaner thread exiting: %s", err, this.getName());
                    throw throwable;
                }
                Object object = CleanerImpl.this.lock;
                synchronized (object) {
                    if (this.equals(CleanerImpl.this.cleanerThread)) {
                        if (stopping) {
                            CleanerImpl.this.cleanerThread = null;
                        } else {
                            CleanerImpl.this.startCleaner();
                        }
                    }
                }
                Log.w(LOG, "Cleaner thread exiting: %s", err, this.getName());
            }
            ref = CleanerImpl.this.lock;
            synchronized (ref) {
                if (this.equals(CleanerImpl.this.cleanerThread)) {
                    if (stopping) {
                        CleanerImpl.this.cleanerThread = null;
                    } else {
                        CleanerImpl.this.startCleaner();
                    }
                }
            }
            Log.w(LOG, "Cleaner thread exiting: %s", err, this.getName());
        }

        public long getRuntimeNanos() {
            return this.runtime.getAndSet(0L);
        }
    }

    private final class CleanableRef
    extends PhantomReference<Object>
    implements Cleaner.Cleanable {
        @NonNull
        private final Cleaner.Cleanable cleanable;
        @NonNull
        private final String name;
        private final long ts;

        CleanableRef(@NonNull Object referent, Cleaner.Cleanable cleanable) {
            super(referent, CleanerImpl.this.zombies);
            this.cleanable = cleanable;
            this.name = referent.getClass().getSimpleName() + ClassUtils.objId(referent);
            this.ts = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clean(boolean finalizing) {
            boolean removed;
            this.clear();
            Set set = CleanerImpl.this.alive;
            synchronized (set) {
                removed = CleanerImpl.this.alive.remove(this);
                int curSize = CleanerImpl.this.alive.size();
                if (curSize < CleanerImpl.this.minSize) {
                    CleanerImpl.this.minSize = curSize;
                }
            }
            if (!removed) {
                Log.w(LOG, "%s was not alive at attempt to clean", this);
            }
            try {
                this.cleanable.clean(finalizing);
            }
            catch (Exception e) {
                Log.w(LOG, "Failed cleaning: %s%s", e, this.name, finalizing ? "!" : "");
            }
        }

        public int hashCode() {
            return this.cleanable.hashCode();
        }

        public boolean equals(@Nullable Object o) {
            return this == o || o instanceof CleanableRef && ((CleanableRef)o).cleanable.equals(this.cleanable);
        }

        @NonNull
        public String toString() {
            return "CleanableRef{" + this.name + ", " + this.cleanable + "}";
        }
    }
}

