/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.internal.fleece.FLArrayIterator;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.fleece.impl.NativeFLArray;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ArrayList;
import java.util.List;

public final class FLArray {
    private static final NativeImpl NATIVE_IMPL = new NativeFLArray();
    private final long peer;
    private final NativeImpl impl;

    @NonNull
    public static FLArray create(long peer) {
        return new FLArray(NATIVE_IMPL, peer);
    }

    @NonNull
    public static FLArrayIterator unmanagedIterator(long peer) {
        return new FLArrayIterator.UnmanagedFLArrayIterator(NATIVE_IMPL, peer);
    }

    private FLArray(@NonNull NativeImpl impl, long peer) {
        Preconditions.assertNotZero(peer, "peer");
        this.peer = peer;
        this.impl = impl;
    }

    public long count() {
        return this.impl.nCount(this.peer);
    }

    @NonNull
    public FLValue get(long index) {
        return FLValue.getFLValue(this.impl.nGet(this.peer, index));
    }

    @NonNull
    public List<Object> asArray() {
        return this.asTypedArray();
    }

    @NonNull
    public <T> List<T> asTypedArray() {
        ArrayList<Object> results = new ArrayList<Object>();
        try (FLArrayIterator itr = this.iterator();){
            FLValue value;
            while ((value = itr.getValue()) != null) {
                results.add(value.asObject());
                itr.next();
            }
        }
        return results;
    }

    @NonNull
    public FLArrayIterator iterator() {
        return new FLArrayIterator.ManagedFLArrayIterator(this.impl, this);
    }

    @Nullable
    <T> T withContent(@NonNull Fn.Function<Long, T> fn) {
        return fn.apply(this.peer);
    }

    public static interface NativeImpl {
        public long nCount(long var1);

        public long nGet(long var1, long var3);

        public long nInit(long var1);

        public long nGetValue(long var1);

        public long nGetValueAt(long var1, int var3);

        public boolean nNext(long var1);

        public void nFree(long var1);
    }
}

