/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.internal.fleece.FLDictIterator;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.fleece.impl.NativeFLDict;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class FLDict {
    private static final NativeImpl NATIVE_IMPL = new NativeFLDict();
    private final NativeImpl impl;
    private final long peer;

    @NonNull
    public static FLDict create(long peer) {
        return new FLDict(NATIVE_IMPL, peer);
    }

    FLDict(@NonNull NativeImpl impl, long peer) {
        this.impl = impl;
        this.peer = Preconditions.assertNotZero(peer, "peer");
    }

    @NonNull
    public FLValue toFLValue() {
        return FLValue.getFLValue(this.peer);
    }

    public long count() {
        return this.impl.nCount(this.peer);
    }

    @Nullable
    public FLValue get(@Nullable String key) {
        if (key == null) {
            return null;
        }
        long hValue = this.impl.nGet(this.peer, key.getBytes(StandardCharsets.UTF_8));
        return hValue != 0L ? FLValue.getFLValue(hValue) : null;
    }

    @NonNull
    public Map<String, Object> asDict() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try (FLDictIterator itr = this.iterator();){
            String key;
            while ((key = itr.getKey()) != null) {
                FLValue val = itr.getValue();
                results.put(key, val.asObject());
                itr.next();
            }
        }
        return results;
    }

    @NonNull
    public FLDictIterator iterator() {
        return new FLDictIterator(this.impl, this);
    }

    @Nullable
    <T> T withContent(@NonNull Fn.Function<Long, T> fn) {
        return fn.apply(this.peer);
    }

    public static interface NativeImpl {
        public long nCount(long var1);

        public long nGet(long var1, @NonNull byte[] var3);

        public long nInit(long var1);

        public long nGetCount(long var1);

        public boolean nNext(long var1);

        @Nullable
        public String nGetKey(long var1);

        public long nGetValue(long var1);

        public void nFree(long var1);
    }
}

