/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.fleece.FLArray;
import com.couchbase.lite.internal.fleece.FLDict;
import com.couchbase.lite.internal.fleece.FLEncodable;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.fleece.impl.NativeFLEncoder;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.utils.ClassUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class FLEncoder
extends C4NativePeer {
    @NonNull
    private static final NativeImpl NATIVE_IMPL = new NativeFLEncoder();
    @NonNull
    protected final NativeImpl impl;
    protected final Map<String, Object> arguments = new HashMap<String, Object>();

    @NonNull
    public static FLEncoder getUnmanagedEncoder(long peer) {
        return new UnmanagedFLEncoder(NATIVE_IMPL, peer);
    }

    @NonNull
    public static FLEncoder getManagedEncoder() {
        return new ManagedFLEncoder(NATIVE_IMPL, NATIVE_IMPL.nCreateFleeceEncoder());
    }

    @NonNull
    public static JSONEncoder getJSONEncoder() {
        return new JSONEncoder(NATIVE_IMPL, NATIVE_IMPL.nCreateJSONEncoder());
    }

    @Nullable
    public static byte[] encodeMap(@Nullable Map<String, Object> options) {
        if (options == null || options.isEmpty()) {
            return null;
        }
        FLEncoder enc = FLEncoder.getManagedEncoder();
        try {
            enc.write(options);
            byte[] byArray = enc.finish();
            if (enc != null) {
                enc.close();
            }
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                if (enc != null) {
                    try {
                        enc.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (LiteCoreException e) {
                Log.w(LogDomain.REPLICATOR, "Failed encoding map: " + options, e);
                return null;
            }
        }
    }

    private FLEncoder(@NonNull NativeImpl impl, long peer) {
        super(peer);
        this.impl = impl;
    }

    @Override
    @NonNull
    public String toString() {
        StringBuilder buf = new StringBuilder("FLEncoder{").append(ClassUtils.objId(this)).append('/').append(super.toString()).append('[');
        boolean first = true;
        for (Map.Entry<String, Object> arg : this.arguments.entrySet()) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append((Object)arg.getKey()).append("=>").append(arg.getValue());
        }
        return buf.append("]}").toString();
    }

    @Override
    public abstract void close();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public FLEncoder setArg(@NonNull String key, @Nullable Object arg) {
        Map<String, Object> map = this.arguments;
        synchronized (map) {
            this.arguments.put(key, arg);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object getArg(@NonNull String key) {
        Map<String, Object> map = this.arguments;
        synchronized (map) {
            return this.arguments.get(key);
        }
    }

    public boolean writeNull() {
        return this.withPeerOrThrow(this.impl::nWriteNull);
    }

    public boolean writeString(@NonNull String value) {
        return this.withPeerOrThrow(p -> this.impl.nWriteString((long)p, value));
    }

    public boolean writeString(@NonNull char[] value) {
        return this.withPeerOrThrow(p -> this.impl.nWriteStringChars((long)p, value));
    }

    public boolean writeData(@NonNull byte[] value) {
        return this.withPeerOrThrow(p -> this.impl.nWriteData((long)p, value));
    }

    public boolean beginDict(long reserve) {
        return this.withPeerOrThrow(p -> this.impl.nBeginDict((long)p, reserve));
    }

    public boolean endDict() {
        return this.withPeerOrThrow(this.impl::nEndDict);
    }

    public boolean beginArray(long reserve) {
        return this.withPeerOrThrow(p -> this.impl.nBeginArray((long)p, reserve));
    }

    public boolean endArray() {
        return this.withPeerOrThrow(this.impl::nEndArray);
    }

    public boolean writeKey(String slice) {
        return this.withPeerOrThrow(p -> this.impl.nWriteKey((long)p, slice));
    }

    public boolean writeValue(@Nullable Object value) {
        return this.withPeerOrThrow(peer -> {
            if (value == null) {
                return this.impl.nWriteNull((long)peer);
            }
            if (value instanceof Boolean) {
                return this.impl.nWriteBool((long)peer, (Boolean)value);
            }
            if (value instanceof Number) {
                if (value instanceof Integer) {
                    return this.impl.nWriteInt((long)peer, ((Integer)value).longValue());
                }
                if (value instanceof Long) {
                    return this.impl.nWriteInt((long)peer, (Long)value);
                }
                if (value instanceof Short) {
                    return this.impl.nWriteInt((long)peer, ((Short)value).longValue());
                }
                if (value instanceof Double) {
                    return this.impl.nWriteDouble((long)peer, (Double)value);
                }
                return this.impl.nWriteFloat((long)peer, ((Float)value).floatValue());
            }
            if (value instanceof String) {
                return this.impl.nWriteString((long)peer, (String)value);
            }
            if (value instanceof char[]) {
                return this.writeString((char[])value);
            }
            if (value instanceof byte[]) {
                return this.impl.nWriteData((long)peer, (byte[])value);
            }
            if (value instanceof List) {
                return this.write((List)value);
            }
            if (value instanceof Map) {
                return this.write((Map)value);
            }
            if (value instanceof FLValue) {
                Boolean val = ((FLValue)value).withContent(hdl -> this.impl.nWriteValue((long)peer, (long)hdl));
                return val != null && val != false;
            }
            if (value instanceof FLDict) {
                Boolean val = ((FLDict)value).withContent(hdl -> this.impl.nWriteValue((long)peer, (long)hdl));
                return val != null && val != false;
            }
            if (value instanceof FLArray) {
                Boolean val = ((FLArray)value).withContent(hdl -> this.impl.nWriteValue((long)peer, (long)hdl));
                return val != null && val != false;
            }
            if (value instanceof FLEncodable) {
                ((FLEncodable)value).encodeTo(this);
                return true;
            }
            return false;
        });
    }

    public boolean write(@Nullable Map<String, Object> map) {
        boolean ok;
        if (map == null) {
            ok = this.beginDict(0L);
        } else {
            ok = this.beginDict(map.size());
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                ok = ok && this.writeKey(entry.getKey());
                ok = ok && this.writeValue(entry.getValue());
            }
        }
        return ok && this.endDict();
    }

    public boolean write(@Nullable List<?> list) {
        boolean ok;
        if (list == null) {
            ok = this.beginArray(0L);
        } else {
            ok = this.beginArray(list.size());
            for (Object item : list) {
                ok = ok && this.writeValue(item);
            }
        }
        return ok && this.endArray();
    }

    public void reset() {
        this.impl.nReset(this.getPeer());
    }

    @NonNull
    public byte[] finish() throws LiteCoreException {
        return this.impl.nFinish(this.getPeer());
    }

    @NonNull
    public FLSliceResult finish2() throws LiteCoreException {
        return this.impl.nFinish2(this.getPeer());
    }

    @NonNull
    public FLSliceResult finish3() throws LiteCoreException {
        return this.impl.nFinish3(this.getPeer());
    }

    public static interface NativeImpl {
        public long nCreateFleeceEncoder();

        public long nCreateJSONEncoder();

        public boolean nWriteNull(long var1);

        public boolean nWriteBool(long var1, boolean var3);

        public boolean nWriteInt(long var1, long var3);

        public boolean nWriteFloat(long var1, float var3);

        public boolean nWriteDouble(long var1, double var3);

        public boolean nWriteString(long var1, @NonNull String var3);

        public boolean nWriteStringChars(long var1, @NonNull char[] var3);

        public boolean nWriteData(long var1, @NonNull byte[] var3);

        public boolean nWriteValue(long var1, long var3);

        public boolean nBeginArray(long var1, long var3);

        public boolean nEndArray(long var1);

        public boolean nBeginDict(long var1, long var3);

        public boolean nEndDict(long var1);

        public boolean nWriteKey(long var1, @NonNull String var3);

        public void nReset(long var1);

        @NonNull
        public byte[] nFinish(long var1) throws LiteCoreException;

        @NonNull
        public FLSliceResult nFinish2(long var1) throws LiteCoreException;

        @NonNull
        public FLSliceResult nFinish3(long var1) throws LiteCoreException;

        @NonNull
        public String nFinishJSON(long var1) throws LiteCoreException;

        public void nFree(long var1);
    }

    static final class UnmanagedFLEncoder
    extends FLEncoder {
        UnmanagedFLEncoder(@NonNull NativeImpl impl, long peer) {
            super(impl, peer);
        }

        @Override
        public void close() {
            this.releasePeer(null, peer -> {
                Map map = this.arguments;
                synchronized (map) {
                    this.arguments.clear();
                }
                this.impl.nReset((long)peer);
            });
        }
    }

    static class ManagedFLEncoder
    extends FLEncoder {
        ManagedFLEncoder(@NonNull NativeImpl impl, long peer) {
            super(impl, peer);
        }

        @Override
        public void close() {
            this.closePeer(null);
        }

        protected void finalize() throws Throwable {
            try {
                this.closePeer(LogDomain.DATABASE);
            }
            finally {
                super.finalize();
            }
        }

        public void closePeer(@Nullable LogDomain domain) {
            this.releasePeer(domain, peer -> {
                NativeImpl nativeImpl = this.impl;
                if (nativeImpl != null) {
                    nativeImpl.nFree((long)peer);
                }
            });
        }
    }

    public static final class JSONEncoder
    extends ManagedFLEncoder {
        private JSONEncoder(@NonNull NativeImpl impl, long peer) {
            super(impl, peer);
        }

        @NonNull
        public String finishJSON() throws LiteCoreException {
            return this.withPeerOrThrow(this.impl::nFinishJSON);
        }

        @Override
        @NonNull
        public byte[] finish() {
            throw new UnsupportedOperationException("finish not supported for JSONEncoders");
        }

        @Override
        @NonNull
        public FLSliceResult finish2() {
            throw new UnsupportedOperationException("finish2 not supported for JSONEncoders");
        }
    }
}

