/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.internal.fleece.impl.NativeFLSliceResult;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.Preconditions;

public abstract class FLSliceResult
implements AutoCloseable {
    private static final NativeImpl NATIVE_IMPL = new NativeFLSliceResult();
    final long base;
    final long size;
    @GuardedBy(value="this")
    private NativeImpl impl;

    @NonNull
    public static FLSliceResult createManagedSlice(long base, long size) {
        return new ManagedFLSliceResult(NATIVE_IMPL, base, size);
    }

    @NonNull
    public static FLSliceResult createUnmanagedSlice(long base, long size) {
        return new UnmanagedFLSliceResult(NATIVE_IMPL, base, size);
    }

    @VisibleForTesting
    @NonNull
    public static FLSliceResult createTestSlice() {
        return FLSliceResult.createManagedSlice(0L, 0L);
    }

    private FLSliceResult(@NonNull NativeImpl impl, long base, long size) {
        this.impl = impl;
        this.base = base;
        this.size = Preconditions.assertNotNegative(size, "size");
    }

    @NonNull
    public String toString() {
        return "SliceResult{" + ClassUtils.objId(this) + " @0x0" + Long.toHexString(this.base) + ", " + this.size + "}";
    }

    public long getBase() {
        return this.base;
    }

    public long getSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] getContent() {
        FLSliceResult fLSliceResult = this;
        synchronized (fLSliceResult) {
            if (this.impl == null) {
                throw new IllegalStateException("Attempt to use a closed slice");
            }
            return this.impl.nGetBuf(this.base, this.size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        NativeImpl ni;
        FLSliceResult fLSliceResult = this;
        synchronized (fLSliceResult) {
            ni = this.impl;
            this.impl = null;
        }
        if (ni != null) {
            this.release(ni);
        }
    }

    protected abstract void release(@NonNull NativeImpl var1);

    public static interface NativeImpl {
        @Nullable
        public byte[] nGetBuf(long var1, long var3);

        public void nRelease(long var1, long var3);
    }

    private static final class ManagedFLSliceResult
    extends FLSliceResult {
        ManagedFLSliceResult(@NonNull NativeImpl impl, long base, long size) {
            super(impl, base, size);
        }

        @Override
        protected void release(@NonNull NativeImpl impl) {
            impl.nRelease(this.base, this.size);
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    private static final class UnmanagedFLSliceResult
    extends FLSliceResult {
        UnmanagedFLSliceResult(@NonNull NativeImpl impl, long base, long size) {
            super(impl, base, size);
        }

        @Override
        protected void release(@NonNull NativeImpl impl) {
        }
    }
}

