/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.internal.fleece.FLArray;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.fleece.MCollection;
import com.couchbase.lite.internal.fleece.MContext;
import com.couchbase.lite.internal.fleece.MValue;
import java.util.ArrayList;
import java.util.List;

public final class MArray
extends MCollection {
    @NonNull
    private final List<MValue> values = new ArrayList<MValue>();
    @Nullable
    private final FLArray baseArray;

    public MArray() {
        super(MContext.NULL, true);
        this.baseArray = null;
    }

    public MArray(@NonNull MArray array, boolean isMutable) {
        super(array, isMutable);
        this.values.addAll(array.values);
        this.baseArray = array.baseArray;
        this.resize();
    }

    public MArray(@NonNull MValue val, @Nullable MCollection parent) {
        super(val, parent, parent != null && parent.hasMutableChildren());
        FLValue value = val.getValue();
        if (value == null) {
            this.baseArray = null;
            return;
        }
        this.baseArray = value.asFLArray();
        this.resize();
    }

    public long count() {
        return this.values.size();
    }

    @NonNull
    public MValue get(long index) {
        this.assertOpen();
        if (index < 0L || index >= (long)this.values.size()) {
            return MValue.EMPTY;
        }
        MValue value = this.values.get((int)index);
        if (value.isEmpty() && this.baseArray != null) {
            value = new MValue(this.baseArray.get(index));
            this.values.set((int)index, value);
        }
        return value;
    }

    public boolean append(Object value) {
        if (!this.isMutable()) {
            throw new CouchbaseLiteError("Cannot append items to a non-mutable MArray");
        }
        return this.insert(this.count(), value);
    }

    public boolean set(long index, Object value) {
        if (!this.isMutable()) {
            throw new CouchbaseLiteError("Cannot set items in a non-mutable MArray");
        }
        this.assertOpen();
        if (index < 0L || index >= this.count()) {
            return false;
        }
        this.mutate();
        this.values.set((int)index, new MValue(value));
        return true;
    }

    public boolean insert(long index, Object value) {
        if (!this.isMutable()) {
            throw new CouchbaseLiteError("Cannot insert items in a non-mutable MArray");
        }
        this.assertOpen();
        if (index < 0L || index > this.count()) {
            return false;
        }
        if (index < this.count()) {
            this.populateValues();
        }
        this.mutate();
        this.values.add((int)index, new MValue(value));
        return true;
    }

    public boolean remove(long start, long num) {
        if (!this.isMutable()) {
            throw new CouchbaseLiteError("Cannot remove items in a non-mutable MArray");
        }
        this.assertOpen();
        long end = start + num;
        if (end <= start) {
            return end == start;
        }
        long count = this.count();
        if (end > count) {
            return false;
        }
        if (end < count) {
            this.populateValues();
        }
        this.mutate();
        this.values.subList((int)start, (int)end).clear();
        return true;
    }

    public void clear() {
        if (!this.isMutable()) {
            throw new CouchbaseLiteError("Cannot clear items in a non-mutable MArray");
        }
        this.assertOpen();
        if (this.values.isEmpty()) {
            return;
        }
        this.mutate();
        this.values.clear();
    }

    @Override
    public void encodeTo(@NonNull FLEncoder enc) {
        this.assertOpen();
        if (!this.isMutated()) {
            if (this.baseArray != null) {
                enc.writeValue(this.baseArray);
                return;
            }
            enc.beginArray(0L);
            enc.endArray();
            return;
        }
        long i = 0L;
        enc.beginArray(this.values.size());
        for (MValue value : this.values) {
            if (!value.isEmpty()) {
                value.encodeTo(enc);
            } else if (this.baseArray != null) {
                enc.writeValue(this.baseArray.get(i));
            }
            ++i;
        }
        enc.endArray();
    }

    private void resize() {
        int count;
        this.assertOpen();
        if (this.baseArray == null) {
            return;
        }
        long newSize = this.baseArray.count();
        if (newSize < (long)(count = this.values.size())) {
            this.values.subList((int)newSize, count).clear();
        } else if (newSize > (long)count) {
            int i = 0;
            while ((long)i < newSize - (long)count) {
                this.values.add(MValue.EMPTY);
                ++i;
            }
        }
    }

    private void populateValues() {
        if (this.baseArray == null) {
            return;
        }
        int size = this.values.size();
        for (int i = 0; i < size; ++i) {
            if (!this.values.get(i).isEmpty()) continue;
            this.values.set(i, new MValue(this.baseArray.get(i)));
        }
    }
}

