/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.internal.fleece.Encodable;
import com.couchbase.lite.internal.fleece.MContext;
import com.couchbase.lite.internal.fleece.MValue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MCollection
implements Encodable {
    @Nullable
    private final MValue slot;
    @Nullable
    private final MContext context;
    @Nullable
    private final MCollection parent;
    private final boolean mutable;
    private final boolean mutableChildren;
    private final AtomicBoolean mutated = new AtomicBoolean();
    private final AtomicInteger localMutations = new AtomicInteger();

    protected MCollection(@Nullable MContext context, boolean isMutable) {
        this(null, null, context, isMutable);
    }

    protected MCollection(@NonNull MCollection original, boolean isMutable) {
        this(null, null, original.getContext(), isMutable);
    }

    protected MCollection(@NonNull MValue slot, @Nullable MCollection parent, boolean isMutable) {
        this(slot, parent, slot.getValue() == null || parent == null ? null : parent.getContext(), isMutable);
        if (slot.isMutated()) {
            this.mutated.set(true);
        }
    }

    private MCollection(@Nullable MValue slot, @Nullable MCollection parent, @Nullable MContext context, boolean isMutable) {
        this.slot = slot;
        this.context = context;
        this.parent = parent;
        this.mutable = isMutable;
        this.mutableChildren = isMutable;
    }

    public final boolean isMutable() {
        return this.mutable;
    }

    public final boolean hasMutableChildren() {
        return this.mutableChildren;
    }

    public boolean isMutated() {
        return this.mutated.get();
    }

    public final long getLocalMutationCount() {
        return this.localMutations.get();
    }

    @Nullable
    public final MContext getContext() {
        return this.context;
    }

    @NonNull
    public final String getStateString() {
        return (this.mutable ? "+" : ".") + (this.isMutated() ? "!" : ".");
    }

    protected void assertOpen() {
        if (this.context != null && this.context.isClosed()) {
            throw new CouchbaseLiteError("Cannot use a Fleece object after its parent has been closed");
        }
    }

    protected final void mutate() {
        this.mutate(true);
    }

    protected final void mutate(boolean isLocal) {
        if (isLocal) {
            this.localMutations.incrementAndGet();
        }
        if (this.mutated.getAndSet(true)) {
            return;
        }
        if (this.slot != null) {
            this.slot.mutate();
        }
        if (this.parent != null) {
            this.parent.mutate(false);
        }
    }
}

