/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.internal.fleece.FLDict;
import com.couchbase.lite.internal.fleece.FLDictIterator;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.fleece.MCollection;
import com.couchbase.lite.internal.fleece.MContext;
import com.couchbase.lite.internal.fleece.MValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MDict
extends MCollection {
    @NonNull
    private final Map<String, MValue> values = new HashMap<String, MValue>();
    @Nullable
    private final FLDict baseDict;
    private long valCount;

    public MDict() {
        super(MContext.NULL, true);
        this.baseDict = null;
    }

    public MDict(@NonNull MDict dict, boolean isMutable) {
        super(dict, isMutable);
        this.values.putAll(dict.values);
        this.baseDict = dict.baseDict;
        this.valCount = dict.valCount;
    }

    public MDict(@NonNull MValue val, @Nullable MCollection parent) {
        super(val, parent, parent != null && parent.hasMutableChildren());
        FLValue value = val.getValue();
        if (value == null) {
            this.baseDict = null;
            return;
        }
        this.baseDict = value.asFLDict();
        this.valCount = this.baseDict.count();
    }

    public long count() {
        return this.valCount;
    }

    public boolean contains(String key) {
        this.assertOpen();
        MValue val = this.values.get(key);
        return val != null ? !val.isEmpty() : this.baseDict != null && this.baseDict.get(key) != null;
    }

    @NonNull
    public List<String> getKeys() {
        this.assertOpen();
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, MValue> entry : this.values.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            keys.add(entry.getKey());
        }
        if (this.baseDict != null && this.baseDict.count() > 0L) {
            try (FLDictIterator itr = this.baseDict.iterator();){
                String key;
                while ((key = itr.getKey()) != null) {
                    if (!this.values.containsKey(key)) {
                        keys.add(key);
                    }
                    itr.next();
                }
            }
        }
        return keys;
    }

    @NonNull
    public MValue get(@NonNull String key) {
        FLValue flValue;
        this.assertOpen();
        MValue mValue = this.values.get(key);
        if (mValue != null) {
            return mValue;
        }
        FLValue fLValue = flValue = this.baseDict == null ? null : this.baseDict.get(key);
        if (flValue == null) {
            return MValue.EMPTY;
        }
        mValue = new MValue(flValue);
        this.values.put(key, mValue);
        return mValue;
    }

    public void set(String key, @NonNull MValue value) {
        if (!this.isMutable()) {
            throw new CouchbaseLiteError("Cannot set items in a non-mutable MDict");
        }
        this.assertOpen();
        boolean hasVal = !value.isEmpty();
        MValue oValue = this.values.get(key);
        if (oValue != null) {
            boolean hasOVal;
            boolean bl = hasOVal = !oValue.isEmpty();
            if (!hasVal && !hasOVal) {
                return;
            }
            this.valCount += (long)((hasVal ? 1 : 0) - (hasOVal ? 1 : 0));
        } else if (this.baseDict != null && this.baseDict.get(key) != null) {
            if (!hasVal) {
                --this.valCount;
            }
        } else {
            if (!hasVal) {
                return;
            }
            ++this.valCount;
        }
        this.mutate();
        this.values.put(key, value);
    }

    public void remove(String key) {
        if (!this.isMutable()) {
            throw new CouchbaseLiteError("Cannot remove items in a non-mutable MDict");
        }
        this.set(key, MValue.EMPTY);
    }

    public void clear() {
        if (!this.isMutable()) {
            throw new CouchbaseLiteError("Cannot clear items from a non-mutable MDict");
        }
        this.assertOpen();
        if (this.valCount == 0L) {
            return;
        }
        this.mutate();
        this.values.clear();
        if (this.baseDict != null && this.baseDict.count() > 0L) {
            try (FLDictIterator itr = this.baseDict.iterator();){
                String key;
                while ((key = itr.getKey()) != null) {
                    this.values.put(key, MValue.EMPTY);
                    itr.next();
                }
            }
        }
        this.valCount = 0L;
    }

    @Override
    public void encodeTo(@NonNull FLEncoder enc) {
        this.assertOpen();
        if (!this.isMutated()) {
            if (this.baseDict != null) {
                enc.writeValue(this.baseDict);
                return;
            }
            enc.beginDict(0L);
            enc.endDict();
            return;
        }
        enc.beginDict(this.valCount);
        for (Map.Entry<String, MValue> entry : this.values.entrySet()) {
            MValue value = entry.getValue();
            if (value.isEmpty()) continue;
            enc.writeKey(entry.getKey());
            value.encodeTo(enc);
        }
        if (this.baseDict != null && this.baseDict.count() > 0L) {
            try (FLDictIterator itr = this.baseDict.iterator();){
                String key;
                while ((key = itr.getKey()) != null) {
                    if (!this.values.containsKey(key)) {
                        enc.writeKey(key);
                        enc.writeValue(itr.getValue());
                    }
                    itr.next();
                }
            }
        }
        enc.endDict();
    }
}

