/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.listener;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.ChangeListener;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.concurrent.Executor;

public class ChangeListenerToken<T>
extends ListenerToken {
    public static final ChangeListenerToken<Void> DUMMY = new ChangeListenerToken<Void>(change -> {}, null, t -> {}){

        @Override
        @NonNull
        public String toString() {
            return "Dummy Token!!";
        }

        @Override
        public void postChange(@NonNull Void change) {
        }
    };
    @NonNull
    private final ChangeListener<T> listener;
    @Nullable
    private String key;

    public ChangeListenerToken(@NonNull ChangeListener<T> listener, @Nullable Executor executor, @NonNull Fn.Consumer<ListenerToken> onRemove) {
        super(executor, onRemove);
        this.listener = Preconditions.assertNotNull(listener, "listener");
    }

    @Override
    @NonNull
    public String toString() {
        return "ChangeListenerToken{@" + this.key + ": " + this.listener + super.toString() + "}";
    }

    @Nullable
    public String getKey() {
        return this.key;
    }

    public void setKey(@Nullable String key) {
        this.key = key;
    }

    public void postChange(@NonNull T change) {
        this.send(() -> this.listener.changed(change));
    }
}

