/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.logging;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractLogSink {
    private final LogLevel level;
    private final Set<LogDomain> domains;

    @NonNull
    protected static Set<LogDomain> defaultDomains(@Nullable Collection<LogDomain> domains) {
        return domains == null ? LogDomain.ALL : Collections.unmodifiableSet(new HashSet<LogDomain>(domains));
    }

    @NonNull
    protected static Set<LogDomain> aggregateDomains(@NonNull LogDomain domain1, @Nullable LogDomain[] domains) {
        HashSet<LogDomain> set = new HashSet<LogDomain>();
        set.add(Preconditions.assertNotNull(domain1, "domain"));
        if (domains != null) {
            set.addAll(Arrays.asList(domains));
        }
        return set;
    }

    @NonNull
    protected static String listDomains(@NonNull Set<LogDomain> domains) {
        StringBuilder domainStr = new StringBuilder("[");
        boolean first = true;
        for (LogDomain domain : domains) {
            if (!first) {
                domainStr.append(", ");
            }
            domainStr.append((Object)domain);
            first = false;
        }
        return domainStr.append(']').toString();
    }

    protected AbstractLogSink(@NonNull LogLevel level, @NonNull Set<LogDomain> domains) {
        this.level = Preconditions.assertNotNull(level, "level");
        this.domains = Preconditions.assertNotNull(domains, "domains");
    }

    @NonNull
    public final LogLevel getLevel() {
        return this.level;
    }

    @NonNull
    public final Set<LogDomain> getDomains() {
        return new HashSet<LogDomain>(this.domains);
    }

    protected abstract void writeLog(@NonNull LogLevel var1, @NonNull LogDomain var2, @NonNull String var3);

    protected final void log(@NonNull LogLevel level, @NonNull LogDomain domain, @NonNull String message) {
        if (this.level.compareTo(level) <= 0 && this.domains.contains((Object)domain)) {
            this.writeLog(level, domain, message);
        }
    }

    protected final boolean similarLevels(@NonNull AbstractLogSink other) {
        return this.level == other.level;
    }

    protected final boolean similarDomains(@NonNull AbstractLogSink other) {
        return this.domains.size() == other.domains.size() && this.domains.containsAll(other.domains);
    }

    protected boolean isLegacy() {
        return false;
    }
}

