/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.logging;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.logging.LogSinksImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.FormatterClosedException;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.Map;

public final class Log {
    public static final String LOG_HEADER = "[JAVA] ";
    private static final String DEFAULT_MSG = "Unknown error";
    private static volatile Map<String, String> errorMessages;

    private Log() {
    }

    public static void init() {
        Log.setStandardErrorMessages(CouchbaseLiteInternal.loadErrorMessages());
    }

    public static void d(@NonNull LogDomain domain, @NonNull String msg) {
        Log.log(LogLevel.DEBUG, domain, null, msg, new Object[0]);
    }

    public static void d(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err) {
        Log.log(LogLevel.DEBUG, domain, err, msg, new Object[0]);
    }

    public static void d(@NonNull LogDomain domain, @NonNull String msg, Object ... args) {
        Log.log(LogLevel.DEBUG, domain, null, msg, args);
    }

    public static void d(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err, Object ... args) {
        Log.log(LogLevel.DEBUG, domain, err, msg, args);
    }

    public static void i(@NonNull LogDomain domain, @NonNull String msg) {
        Log.log(LogLevel.INFO, domain, null, msg, new Object[0]);
    }

    public static void i(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err) {
        Log.log(LogLevel.INFO, domain, err, msg, new Object[0]);
    }

    public static void info(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err) {
        Log.i(domain, msg, err);
    }

    public static void i(@NonNull LogDomain domain, @NonNull String msg, Object ... args) {
        Log.log(LogLevel.INFO, domain, null, msg, args);
    }

    public static void i(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err, Object ... args) {
        Log.log(LogLevel.INFO, domain, err, msg, args);
    }

    public static void w(@NonNull LogDomain domain, @NonNull String msg) {
        Log.log(LogLevel.WARNING, domain, null, msg, new Object[0]);
    }

    public static void w(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err) {
        Log.log(LogLevel.WARNING, domain, err, msg, new Object[0]);
    }

    public static void w(@NonNull LogDomain domain, @NonNull String msg, Object ... args) {
        Log.log(LogLevel.WARNING, domain, null, msg, args);
    }

    public static void w(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err, Object ... args) {
        Log.log(LogLevel.WARNING, domain, err, msg, args);
    }

    public static void e(@NonNull LogDomain domain, @NonNull String msg) {
        Log.log(LogLevel.ERROR, domain, null, msg, new Object[0]);
    }

    public static void e(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err) {
        Log.log(LogLevel.ERROR, domain, err, msg, new Object[0]);
    }

    public static void e(@NonNull LogDomain domain, @NonNull String msg, Object ... args) {
        Log.log(LogLevel.ERROR, domain, null, msg, args);
    }

    public static void e(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err, Object ... args) {
        Log.log(LogLevel.ERROR, domain, err, msg, args);
    }

    @NonNull
    public static String lookupStandardMessage(@Nullable String msg) {
        if (msg == null) {
            return DEFAULT_MSG;
        }
        String message = errorMessages == null ? msg : errorMessages.get(msg);
        return message == null ? msg : message;
    }

    @NonNull
    public static String formatStandardMessage(@Nullable String msg, Object ... args) {
        return String.format(Locale.ENGLISH, Log.lookupStandardMessage(msg), args);
    }

    @NonNull
    public static String formatStackTrace(@NonNull Throwable err) {
        StringWriter sw = new StringWriter();
        err.printStackTrace(new PrintWriter(sw));
        return System.lineSeparator() + sw;
    }

    @VisibleForTesting
    public static void setStandardErrorMessages(@NonNull Map<String, String> stdErrMsgs) {
        errorMessages = Collections.unmodifiableMap(new HashMap<String, String>(stdErrMsgs));
    }

    private static void log(@NonNull LogLevel level, @NonNull LogDomain domain, @Nullable Throwable err, @NonNull String msg, Object ... args) {
        String message;
        LogSinksImpl logSinks;
        if (level == null) {
            level = LogLevel.INFO;
        }
        if ((logSinks = LogSinksImpl.getLogSinks()) == null || !logSinks.shouldLog(level, domain)) {
            return;
        }
        if (msg == null) {
            message = "";
        } else {
            message = Log.lookupStandardMessage(msg);
            if (args != null && args.length > 0) {
                message = Log.formatMessage(message, args);
            }
        }
        if (err != null) {
            message = message + Log.formatStackTrace(err);
        }
        logSinks.writeToSinks(level, domain != null ? domain : LogDomain.DATABASE, LOG_HEADER + message);
    }

    @NonNull
    private static String formatMessage(@NonNull String msg, Object ... args) {
        try {
            return String.format(Locale.ENGLISH, msg, args);
        }
        catch (FormatterClosedException | IllegalFormatException runtimeException) {
            return msg;
        }
    }
}

