/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.logging;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.core.C4Log;
import com.couchbase.lite.internal.core.CBLVersion;
import com.couchbase.lite.internal.logging.AbstractLogSink;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.logging.BaseLogSink;
import com.couchbase.lite.logging.ConsoleLogSink;
import com.couchbase.lite.logging.FileLogSink;
import com.couchbase.lite.logging.LogSinks;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class LogSinksImpl
implements LogSinks {
    private static final int LOG_QUEUE_MAX = 16;
    @NonNull
    private static final AtomicReference<LogSinksImpl> LOG_SINKS = new AtomicReference();
    @NonNull
    private final AtomicReference<LogLevel> logLevel = new AtomicReference<LogLevel>(LogLevel.NONE);
    @NonNull
    private final AtomicReference<LogLevel> callbackLevel = new AtomicReference<LogLevel>(LogLevel.NONE);
    @NonNull
    private final AtomicReference<Set<LogDomain>> logDomains = new AtomicReference(new HashSet());
    @NonNull
    private final AtomicBoolean warned = new AtomicBoolean();
    @NonNull
    private final AtomicReference<Executor> customLogQueue = new AtomicReference();
    @NonNull
    private final C4Log c4Log;
    @Nullable
    private FileLogSink fileLogSink;
    @Nullable
    private ConsoleLogSink consoleLogSink;
    @Nullable
    private BaseLogSink customLogSink;
    private Boolean usedLegacyLogging;

    @Nullable
    public static LogSinksImpl getLogSinks() {
        return LOG_SINKS.get();
    }

    public static void initLogging() {
        Log.init();
        LogSinksImpl logSinks = new LogSinksImpl(C4Log.create());
        ConsoleLogSink consoleLogSink = new ConsoleLogSink(CouchbaseLiteInternal.debugging() ? LogLevel.DEBUG : LogLevel.WARNING, (Collection<LogDomain>)LogDomain.ALL);
        logSinks.setConsole(consoleLogSink);
        ((AbstractLogSink)consoleLogSink).writeLog(LogLevel.INFO, LogDomain.DATABASE, "CBL-JAVA Initialized: " + CBLVersion.getVersionInfo());
        LOG_SINKS.set(logSinks);
        logSinks.usedLegacyLogging = null;
    }

    public static void logToCore(@NonNull LogLevel level, @NonNull LogDomain domain, @NonNull String message) {
        LogSinksImpl sinks = LOG_SINKS.get();
        if (sinks == null) {
            return;
        }
        sinks.c4Log.logToCore(domain, level, message);
    }

    public static void logFromCore(@NonNull LogLevel level, @NonNull LogDomain domain, @Nullable String message) {
        LogSinksImpl sinks = LOG_SINKS.get();
        if (sinks == null) {
            return;
        }
        sinks.writeToLocalLogSinks(level, domain, message);
    }

    public static void warnNoFileLogSink() {
        LogSinksImpl sinks = LOG_SINKS.get();
        if (sinks == null) {
            return;
        }
        sinks.warnIfNoFileLogSink();
    }

    public static void logFailure(@NonNull String name, @Nullable Exception err) {
        ConsoleLogSink console;
        LogSinksImpl sinks;
        String msg = "Log failure: " + name;
        if (err != null) {
            msg = msg + "\n" + Log.formatStackTrace(err);
        }
        if ((sinks = LOG_SINKS.get()) != null && (console = sinks.consoleLogSink) != null) {
            try {
                console.log(LogLevel.WARNING, LogDomain.DATABASE, msg);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.err.println("WARNING: " + msg);
    }

    private LogSinksImpl(@NonNull C4Log c4Log) {
        this.c4Log = c4Log;
    }

    @Override
    @Nullable
    public FileLogSink getFile() {
        return this.fileLogSink;
    }

    @Override
    public void setFile(@Nullable FileLogSink newSink) {
        if (Objects.equals(this.fileLogSink, newSink)) {
            return;
        }
        this.forbidNewAndLegacyLogging(newSink);
        if (newSink == null) {
            LogLevel newLevel = LogLevel.NONE;
            this.c4Log.initFileLogging("", newLevel, 0, 0L, false, "");
        } else {
            LogLevel newLevel = newSink.getLevel();
            if (newSink.similar(this.fileLogSink)) {
                this.c4Log.setFileLogLevel(newLevel);
            } else {
                this.c4Log.initFileLogging(newSink.getDirectory(), newLevel, newSink.getMaxKeptFiles(), newSink.getMaxFileSize(), newSink.isPlainText(), CBLVersion.getVersionInfo());
            }
        }
        this.fileLogSink = newSink;
        this.setLogFilter();
        this.warnIfNoFileLogSink();
    }

    @Override
    @Nullable
    public ConsoleLogSink getConsole() {
        return this.consoleLogSink;
    }

    @Override
    public void setConsole(@Nullable ConsoleLogSink newSink) {
        this.forbidNewAndLegacyLogging(newSink);
        this.consoleLogSink = newSink;
        this.setLogFilter();
    }

    @Override
    @Nullable
    public BaseLogSink getCustom() {
        return this.customLogSink;
    }

    @Override
    public void setCustom(@Nullable BaseLogSink newSink) {
        this.forbidNewAndLegacyLogging(newSink);
        this.customLogSink = newSink;
        if (newSink != null && this.customLogQueue.get() == null) {
            this.customLogQueue.compareAndSet(null, new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(16)));
        }
        this.setLogFilter();
    }

    public void writeToSinks(@NonNull LogLevel level, @NonNull LogDomain domain, @NonNull String msg) {
        try {
            this.log(this.fileLogSink, level, domain, msg);
        }
        catch (Exception e) {
            LogSinksImpl.logFailure("File", e);
        }
        this.writeToLocalLogSinks(level, domain, msg);
    }

    public void writeToLocalLogSinks(@NonNull LogLevel level, @NonNull LogDomain domain, @Nullable String message) {
        String msg = message == null ? "" : message;
        ConsoleLogSink console = this.consoleLogSink;
        try {
            this.log(console, level, domain, msg);
        }
        catch (Exception e) {
            LogSinksImpl.logFailure("Console", e);
        }
        Executor logQueue = this.customLogQueue.get();
        BaseLogSink custom = this.customLogSink;
        if (logQueue == null || custom == null || custom.getLevel().compareTo(level) > 0) {
            return;
        }
        try {
            logQueue.execute(() -> {
                try {
                    custom.log(level, domain, msg);
                }
                catch (Exception e) {
                    LogSinksImpl.logFailure("Custom", e);
                }
            });
        }
        catch (Exception e) {
            LogSinksImpl.logFailure("Custom", e);
        }
    }

    public boolean shouldLog(@NonNull LogLevel level, @NonNull LogDomain domain) {
        return this.logLevel.get().compareTo(level) <= 0 && this.logDomains.get().contains((Object)domain);
    }

    @VisibleForTesting
    @NonNull
    public C4Log getC4Log() {
        return this.c4Log;
    }

    private void forbidNewAndLegacyLogging(@Nullable AbstractLogSink newSink) {
        if (newSink == null) {
            return;
        }
        Boolean usedLegacyLogging = this.usedLegacyLogging;
        this.usedLegacyLogging = newSink.isLegacy();
        if (usedLegacyLogging == null) {
            return;
        }
        if (!usedLegacyLogging.equals(this.usedLegacyLogging)) {
            throw new CouchbaseLiteError("Cannot mix new and legacy logging");
        }
    }

    private void setLogFilter() {
        LogLevel l;
        HashSet<LogDomain> newDomains = new HashSet<LogDomain>();
        LogLevel platformLogLevel = LogLevel.NONE;
        AbstractLogSink sink = this.consoleLogSink;
        if (sink != null) {
            l = sink.getLevel();
            if (l.compareTo(platformLogLevel) < 0) {
                platformLogLevel = l;
            }
            newDomains.addAll(sink.getDomains());
        }
        if ((sink = this.customLogSink) != null) {
            l = sink.getLevel();
            if (l.compareTo(platformLogLevel) < 0) {
                platformLogLevel = l;
            }
            newDomains.addAll(sink.getDomains());
        }
        LogLevel fileLogLevel = LogLevel.NONE;
        if (this.fileLogSink != null) {
            fileLogLevel = this.fileLogSink.getLevel();
        }
        if (platformLogLevel.compareTo(fileLogLevel) < 0) {
            fileLogLevel = platformLogLevel;
        }
        if ((l = this.callbackLevel.getAndSet(platformLogLevel)) != platformLogLevel) {
            this.c4Log.setCallbackLevel(platformLogLevel);
        }
        this.logLevel.set(fileLogLevel);
        this.logDomains.set(newDomains);
        this.c4Log.setLogFilter(fileLogLevel, platformLogLevel, newDomains);
    }

    private void warnIfNoFileLogSink() {
        FileLogSink sink = this.fileLogSink;
        if (sink != null && sink.getLevel() != LogLevel.NONE && !this.warned.getAndSet(true)) {
            return;
        }
        ((AbstractLogSink)new ConsoleLogSink(LogLevel.WARNING, LogDomain.DATABASE, new LogDomain[0])).writeLog(LogLevel.WARNING, LogDomain.DATABASE, "Database.log.getFile().getConfig() is now null: logging is disabled.  Log files required for product support are not being generated.");
    }

    private void log(@Nullable AbstractLogSink sink, @NonNull LogLevel level, @NonNull LogDomain domain, @NonNull String message) {
        if (sink != null) {
            sink.log(level, domain, message);
        }
    }
}

