/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.replicator;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.core.C4Replicator;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.utils.ClassUtils;
import java.util.concurrent.Executor;

public abstract class BaseReplicator
implements AutoCloseable {
    private final Object lock = new Object();
    protected final Executor dispatcher = CouchbaseLiteInternal.getExecutionService().getSerialExecutor();
    @GuardedBy(value="lock")
    @Nullable
    private C4Replicator c4Replicator;
    @GuardedBy(value="lock")
    @NonNull
    private String id = this.getReplId(null) + ClassUtils.objId(this);

    protected BaseReplicator() {
    }

    protected final void setC4Replicator(@NonNull C4Replicator newC4Repl) {
        this.setC4ReplicatorInternal(newC4Repl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected final String getId() {
        Object object = this.getReplicatorLock();
        synchronized (object) {
            return this.id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final C4Replicator getC4Replicator() {
        Object object = this.getReplicatorLock();
        synchronized (object) {
            return this.c4Replicator;
        }
    }

    protected final void closeC4Replicator() {
        this.setC4ReplicatorInternal(null);
    }

    @NonNull
    protected final Object getReplicatorLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setC4ReplicatorInternal(@Nullable C4Replicator newC4Repl) {
        String newReplId;
        C4Replicator oldC4Repl;
        String oldReplId;
        Object object = this.getReplicatorLock();
        synchronized (object) {
            oldReplId = this.id;
            oldC4Repl = this.c4Replicator;
            newReplId = this.getReplId(newC4Repl);
            this.id = newReplId + ClassUtils.objId(this);
            this.c4Replicator = newC4Repl;
        }
        Log.d(LogDomain.REPLICATOR, "%s: new c4Repl: %s", oldReplId, newReplId, this);
        if (oldC4Repl != null) {
            oldC4Repl.close();
        }
    }

    @NonNull
    private String getReplId(@Nullable C4Replicator repl) {
        return repl == null ? "unattached" : repl.getReplId();
    }
}

