/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.sockets;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.sockets.CBLSocketException;
import com.couchbase.lite.internal.sockets.CloseStatus;
import com.couchbase.lite.internal.sockets.SocketFromRemote;
import com.couchbase.lite.internal.sockets.SocketToRemote;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.Fn;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Cookie;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public final class OkHttpSocket
extends WebSocketListener
implements SocketToRemote {
    private static final LogDomain LOG_DOMAIN = LogDomain.NETWORK;
    @NonNull
    private static final OkHttpClient BASE_HTTP_CLIENT = new OkHttpClient.Builder().connectTimeout(0L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).build();
    @NonNull
    private static final WebSocket NULL_WS = new WebSocket(){

        @NonNull
        public Request request() {
            throw new UnsupportedOperationException();
        }

        public long queueSize() {
            throw new UnsupportedOperationException();
        }

        public boolean send(@NonNull String text) {
            throw new UnsupportedOperationException();
        }

        public boolean send(@NonNull ByteString bytes) {
            throw new UnsupportedOperationException();
        }

        public boolean close(int code, @Nullable String reason) {
            throw new UnsupportedOperationException();
        }

        public void cancel() {
            throw new UnsupportedOperationException();
        }
    };
    private final SocketFactory socketFactory;
    private final AtomicReference<WebSocket> toRemote = new AtomicReference();
    private final AtomicReference<SocketFromRemote> toCore = new AtomicReference<SocketFromRemote.Constants>(SocketFromRemote.Constants.NULL);

    @NonNull
    public static List<Cookie> parseCookies(@NonNull HttpUrl url, @NonNull String cookies) {
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
        StringTokenizer st = new StringTokenizer(cookies, ";");
        while (st.hasMoreTokens()) {
            Cookie cookie = Cookie.parse((HttpUrl)url, (String)st.nextToken().trim());
            if (cookie == null) continue;
            cookieList.add(cookie);
        }
        return cookieList;
    }

    public OkHttpSocket() {
        this(OkHttpClient::newWebSocket);
    }

    @VisibleForTesting
    OkHttpSocket(@NonNull SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    @NonNull
    public String toString() {
        return "OkHttpSocket" + ClassUtils.objId(this);
    }

    @Override
    public void close() {
        CloseStatus status = new CloseStatus(6, 1001, "Closed by client");
        SocketFromRemote core = this.toCore.getAndSet(null);
        WebSocket remote = this.toRemote.getAndSet(null);
        if (remote != null) {
            remote.close(status.code, status.message);
        }
        if (core != null && !SocketFromRemote.Constants.NULL.equals(core)) {
            core.remoteClosed(status);
        }
    }

    @Override
    public void init(@NonNull SocketFromRemote core) {
        Log.d(LOG_DOMAIN, "%s.init: %s", this, core);
        if (this.toCore.compareAndSet(SocketFromRemote.Constants.NULL, core)) {
            return;
        }
        SocketFromRemote prevCore = this.toCore.get();
        if (prevCore == null) {
            Log.w(LOG_DOMAIN, "Ignoring attempt to initialize a closed socket socket: %s", this);
            return;
        }
        if (core.equals(prevCore)) {
            Log.w(LOG_DOMAIN, "Ignoring socket re-initialization: %s", this);
            return;
        }
        throw new CBLSocketException(5, 16, "Attempt to re-initialize socket(" + prevCore + "): " + core);
    }

    @Override
    public boolean openRemote(@NonNull URI uri, @Nullable Map<String, Object> options) {
        Log.d(LOG_DOMAIN, "%s.open: %s", this, uri);
        SocketFromRemote core = this.getOpenCore();
        if (core == null) {
            return false;
        }
        if (!this.toRemote.compareAndSet(null, NULL_WS)) {
            Log.d(LOG_DOMAIN, "Attempt to re-open open socket: %s", this);
            return false;
        }
        OkHttpClient.Builder builder = BASE_HTTP_CLIENT.newBuilder();
        core.setupRemoteSocketFactory(builder);
        if (!this.toRemote.compareAndSet(NULL_WS, this.socketFactory.create(builder.build(), this.newRequest(uri, options), this))) {
            throw new CBLSocketException(5, 13, "Failed setting remote web socket");
        }
        return true;
    }

    @Override
    public boolean writeToRemote(@NonNull byte[] data) {
        int nBytes = data == null ? -1 : data.length;
        Log.d(LOG_DOMAIN, "%s.write(%d)", this, nBytes);
        if (nBytes <= 0) {
            return true;
        }
        this.getOpenCore();
        return this.withRemote(remote -> remote.send(ByteString.of((byte[])data, (int)0, (int)data.length)));
    }

    @Override
    public boolean closeRemote(@NonNull CloseStatus status) {
        Log.d(LOG_DOMAIN, "%s.close: %s", this, status);
        this.getOpenCore();
        return this.withRemote(remote -> remote.close(status.code, status.message));
    }

    @Override
    public void cancelRemote() {
        Log.d(LOG_DOMAIN, "%s.cancel", this);
        WebSocket remote = this.toRemote.get();
        this.closeSocket(remote, core -> {
            if (remote != null) {
                remote.cancel();
            }
        });
    }

    public void onOpen(@NonNull WebSocket ws, @NonNull Response resp) {
        Log.d(LOG_DOMAIN, "%s.onOpen: %s", this, resp);
        SocketFromRemote core = this.getOpenCore();
        if (core == null || !this.verifyRemote(ws)) {
            return;
        }
        HashMap<String, String> headers = null;
        Headers httpHeaders = resp.headers();
        if (httpHeaders != null && httpHeaders.size() > 0) {
            headers = new HashMap<String, String>();
            for (int i = 0; i < httpHeaders.size(); ++i) {
                headers.put(httpHeaders.name(i), httpHeaders.value(i));
            }
        }
        core.remoteOpened(resp.code(), headers);
    }

    public void onMessage(@NonNull WebSocket ws, @NonNull String text) {
        int len = text == null ? -1 : text.length();
        Log.d(LOG_DOMAIN, "%s.onText(%d)", this, len);
        if (len <= 0) {
            return;
        }
        this.withCore(ws, core -> core.remoteWrites(text.getBytes(StandardCharsets.UTF_8)));
    }

    public void onMessage(@NonNull WebSocket ws, @NonNull ByteString bytes) {
        int len = bytes == null ? -1 : bytes.size();
        Log.d(LOG_DOMAIN, "%s.onBytes(%d)", this, len);
        if (len <= 0) {
            return;
        }
        this.withCore(ws, core -> core.remoteWrites(bytes.toByteArray()));
    }

    public void onClosing(@NonNull WebSocket ws, int code, @NonNull String message) {
        Log.d(LOG_DOMAIN, "%s.onClosing(%d): '%s'", this, code, message);
        CloseStatus status = new CloseStatus(code, message);
        this.withCore(ws, core -> core.remoteRequestsClose(status));
    }

    public void onClosed(@NonNull WebSocket ws, int code, @NonNull String message) {
        Log.d(LOG_DOMAIN, "%s.onClosed(%d): '%s'", this, code, message);
        this.getOpenCore();
        this.closeSocket(ws, core -> core.remoteClosed(new CloseStatus(6, code, message)));
    }

    public void onFailure(@NonNull WebSocket ws, @NonNull Throwable err, @Nullable Response resp) {
        Log.d(LOG_DOMAIN, "%s.onFailure: %s", err, this, resp);
        this.getOpenCore();
        if (resp == null) {
            this.closeSocket(ws, core -> core.remoteFailed(err));
            return;
        }
        this.closeSocket(ws, core -> core.remoteClosed(new CloseStatus(6, resp.code(), resp.message())));
    }

    @VisibleForTesting
    @Nullable
    SocketFromRemote getCore() {
        return this.toCore.get();
    }

    @VisibleForTesting
    @Nullable
    WebSocket getRemote() {
        return this.toRemote.get();
    }

    @NonNull
    private Request newRequest(@NonNull URI uri, @Nullable Map<String, Object> options) {
        Request.Builder builder = new Request.Builder();
        builder.url(uri.toString());
        String host = uri.getHost();
        if (uri.getPort() >= 0) {
            host = host + ":" + uri.getPort();
        }
        builder.header("Host", host);
        if (options != null) {
            Object protocols;
            Object extraHeaders = options.get("headers");
            if (extraHeaders instanceof Map) {
                for (Map.Entry header : ((Map)extraHeaders).entrySet()) {
                    builder.header(header.getKey().toString(), header.getValue().toString());
                }
            }
            if ((protocols = options.get("WS-Protocols")) instanceof String) {
                builder.header("Sec-WebSocket-Protocol", (String)protocols);
            }
        }
        return builder.build();
    }

    private boolean withRemote(@NonNull Fn.Function<WebSocket, Boolean> op) {
        WebSocket remote = this.toRemote.get();
        if (remote == null) {
            return false;
        }
        Boolean val = op.apply(remote);
        return val != null && val != false;
    }

    private void withCore(@Nullable WebSocket ws, @NonNull Fn.Consumer<SocketFromRemote> op) {
        SocketFromRemote core = this.getOpenCore();
        if (core != null && this.verifyRemote(ws)) {
            op.accept(core);
        }
    }

    private void closeSocket(@Nullable WebSocket ws, @NonNull Fn.Consumer<SocketFromRemote> delegate) {
        WebSocket remote;
        if (!this.toRemote.compareAndSet(ws, null) && (remote = this.toRemote.get()) != null) {
            Log.w(LOG_DOMAIN, "Ignoring attempt to close the wrong socket: %s, %s", ws, remote);
            return;
        }
        SocketFromRemote core = this.toCore.getAndSet(null);
        if (core != null && !SocketFromRemote.Constants.NULL.equals(core)) {
            delegate.accept(core);
        }
    }

    @Nullable
    private SocketFromRemote getOpenCore() {
        SocketFromRemote core = this.toCore.get();
        if (SocketFromRemote.Constants.NULL.equals(core)) {
            throw new CouchbaseLiteError("Attempt to use socket before initialization");
        }
        return core;
    }

    private boolean verifyRemote(@Nullable WebSocket ws) {
        WebSocket remote = this.toRemote.get();
        if (Objects.equals(ws, remote)) {
            return true;
        }
        if (remote == null) {
            Log.d(LOG_DOMAIN, "Ignoring operation on closed socket: %s", ws);
            return false;
        }
        Log.w(LOG_DOMAIN, "Ignoring operation on the wrong socket(%s): %s", remote, ws);
        return false;
    }

    private static interface SocketFactory {
        @NonNull
        public WebSocket create(@NonNull OkHttpClient var1, @NonNull Request var2, @NonNull WebSocketListener var3);
    }
}

