/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;

public final class StateMachine<T extends Enum<T>> {
    @NonNull
    private final LogDomain domain;
    @Nullable
    private final T failureState;
    @NonNull
    private final EnumMap<T, EnumSet<T>> transitions;
    @NonNull
    private T state;

    private StateMachine(@NonNull LogDomain domain, @NonNull T initialState, @Nullable T failureState, @NonNull EnumMap<T, EnumSet<T>> transitions) {
        this.domain = domain;
        this.state = initialState;
        this.failureState = failureState;
        this.transitions = transitions;
    }

    @NonNull
    public String toString() {
        return ClassUtils.objId(this);
    }

    @SafeVarargs
    public final boolean assertState(T ... expected) {
        Preconditions.assertPositive(expected.length, "expected states length");
        for (T s : expected) {
            if (s != this.state) continue;
            return true;
        }
        if (this.state != this.failureState) {
            Log.d(this.domain, "StateMachine%s: unexpected state %s %s", new Exception(), this, this.state, Arrays.toString(expected));
        }
        return false;
    }

    public boolean setState(@NonNull T nextState) {
        EnumSet<T> legalStates = this.transitions.get(this.state);
        if (nextState == this.failureState || legalStates != null && legalStates.contains(nextState)) {
            Log.d(this.domain, "StateMachine%s: transition %s => %s", this, this.state, nextState);
            this.state = nextState;
            return true;
        }
        if (this.state != this.failureState) {
            Log.d(this.domain, "StateMachine%s: no transition: %s => %s %s", this, new Exception(), this.state, nextState, legalStates);
        }
        return false;
    }

    @VisibleForTesting
    @NonNull
    public T getCurrentState() {
        return this.state;
    }

    /* synthetic */ StateMachine(LogDomain x0, Enum x1, Enum x2, EnumMap x3, 1 x4) {
        this(x0, x1, x2, x3);
    }

    public static class Builder<S extends Enum<S>> {
        @NonNull
        private final LogDomain domain;
        @NonNull
        private final S initialState;
        @Nullable
        private final S failureState;
        @NonNull
        private final EnumMap<S, EnumSet<S>> transitions;

        public Builder(@NonNull Class<S> klass, @NonNull LogDomain log, @NonNull S initState, @Nullable S failState) {
            this.transitions = new EnumMap(klass);
            this.domain = log;
            this.initialState = initState;
            this.failureState = failState;
        }

        @SafeVarargs
        @NonNull
        public final Builder<S> addTransition(@NonNull S source, @NonNull S target1, S ... targets) {
            if (source == this.failureState) {
                throw new IllegalArgumentException("transitions from the failure state are illegal");
            }
            this.transitions.put(source, EnumSet.of(target1, targets));
            return this;
        }

        @NonNull
        public StateMachine<S> build() {
            return new StateMachine(this.domain, (Enum)this.initialState, (Enum)this.failureState, this.transitions, null);
        }
    }
}

