/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import java.io.PrintStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;

public final class SystemStream {
    private static final String LOG_TAG = "/CouchbaseLite/";
    private static final int THREAD_FIELD_LEN = 7;
    private static final String THREAD_FIELD_PAD = String.join((CharSequence)"", Collections.nCopies(7, " "));
    private static final ThreadLocal<DateTimeFormatter> TS_FORMAT = ThreadLocal.withInitial(() -> DateTimeFormatter.ofPattern("MM-dd HH:mm:ss.SSS"));

    private SystemStream() {
    }

    public static void print(@NonNull LogLevel level, @NonNull String domain, @NonNull String message, @Nullable Throwable err) {
        PrintStream logStream = CouchbaseLiteInternal.debugging() || LogLevel.WARNING.compareTo(level) > 0 ? System.out : System.err;
        String tf = THREAD_FIELD_PAD + Thread.currentThread().getId();
        logStream.println(TS_FORMAT.get().format(LocalDateTime.now()) + tf.substring(tf.length() - 7) + " " + (Object)((Object)level) + LOG_TAG + domain + ": " + message);
        if (err != null) {
            err.printStackTrace(logStream);
        }
    }
}

