/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.logging;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.internal.logging.AbstractLogSink;
import com.couchbase.lite.internal.utils.SystemStream;
import java.util.Collection;
import java.util.Objects;

public class ConsoleLogSink
extends AbstractLogSink {
    public ConsoleLogSink(@NonNull LogLevel level) {
        this(level, (Collection<LogDomain>)null);
    }

    public ConsoleLogSink(@NonNull LogLevel level, @NonNull LogDomain domain1, LogDomain ... domains) {
        this(level, (Collection<LogDomain>)ConsoleLogSink.aggregateDomains(domain1, domains));
    }

    public ConsoleLogSink(@NonNull LogLevel level, @Nullable Collection<LogDomain> domains) {
        super(level, ConsoleLogSink.defaultDomains(domains));
    }

    @NonNull
    public final String toString() {
        return "ConsoleLogSink{" + ConsoleLogSink.listDomains(this.getDomains()) + "@" + (Object)((Object)this.getLevel()) + "}";
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.getLevel(), this.getDomains()});
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConsoleLogSink)) {
            return false;
        }
        ConsoleLogSink other = (ConsoleLogSink)o;
        return this.similarLevels(other) && this.similarDomains(other);
    }

    @Override
    protected void writeLog(@NonNull LogLevel level, @NonNull LogDomain domain, @NonNull String message) {
        SystemStream.print(level, domain.name(), message, null);
    }
}

