/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.logging;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.internal.logging.AbstractLogSink;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.logging.LogSinksImpl;
import com.couchbase.lite.internal.utils.Preconditions;
import java.io.File;
import java.util.Objects;

public class FileLogSink
extends AbstractLogSink {
    @NonNull
    private final String directory;
    private final int maxKeptFiles;
    private final long maxFileSize;
    private final boolean plainText;

    protected FileLogSink(@NonNull Builder builder) {
        super(builder.level, LogDomain.ALL);
        String dir = builder.directory;
        if (dir == null) {
            throw new IllegalStateException("A file logger must specify a log file directory path");
        }
        this.directory = dir;
        this.maxKeptFiles = builder.maxKeptFiles;
        this.maxFileSize = builder.maxFileSize;
        this.plainText = builder.plainText;
    }

    @NonNull
    public final String getDirectory() {
        return this.directory;
    }

    public final int getMaxKeptFiles() {
        return this.maxKeptFiles;
    }

    public final long getMaxFileSize() {
        return this.maxFileSize;
    }

    public final boolean isPlainText() {
        return this.plainText;
    }

    @NonNull
    public final String toString() {
        return "FileLogSink{" + (this.isLegacy() ? "!" : "") + (this.plainText ? "+" : "") + FileLogSink.listDomains(this.getDomains()) + "@" + (Object)((Object)this.getLevel()) + ": " + this.directory + ", " + this.maxFileSize + ", " + this.maxKeptFiles + "}";
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.getLevel(), this.directory, this.maxKeptFiles, this.maxFileSize});
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileLogSink)) {
            return false;
        }
        FileLogSink other = (FileLogSink)o;
        return this.similar(other) && this.similarLevels(other) && this.similarDomains(other);
    }

    public final boolean similar(@Nullable FileLogSink other) {
        return other != null && this.directory.equals(other.directory) && this.maxKeptFiles == other.maxKeptFiles && this.maxFileSize == other.maxFileSize && this.plainText == other.plainText;
    }

    @Override
    protected void writeLog(@NonNull LogLevel level, @NonNull LogDomain domain, @NonNull String message) {
        LogSinksImpl.logToCore(level, domain, message);
    }

    public static final class Builder {
        @Nullable
        private String directory;
        @NonNull
        private LogLevel level = LogLevel.WARNING;
        private int maxKeptFiles = 2;
        private long maxFileSize = 524288L;
        private boolean plainText = false;

        public Builder() {
        }

        public Builder(@NonNull Builder builder) {
            this.directory = builder.directory;
            this.level = builder.getLevel();
            this.maxKeptFiles = builder.maxKeptFiles;
            this.maxFileSize = builder.maxFileSize;
            this.plainText = builder.plainText;
        }

        public Builder(@NonNull FileLogSink sink) {
            this.directory = sink.directory;
            this.level = sink.getLevel();
            this.maxKeptFiles = sink.maxKeptFiles;
            this.maxFileSize = sink.maxFileSize;
            this.plainText = sink.plainText;
        }

        @Nullable
        public String getDirectory() {
            return this.directory;
        }

        @NonNull
        public Builder setDirectory(@NonNull String directory) {
            String logDirPath = Preconditions.assertNotEmpty(directory, "directory");
            File logDir = new File(logDirPath);
            if (logDir.exists()) {
                if (!logDir.isDirectory()) {
                    Log.w(LogDomain.DATABASE, logDir.getAbsolutePath() + " is not a directory");
                }
            } else if (!logDir.mkdirs()) {
                Log.w(LogDomain.DATABASE, "Cannot create log directory: " + logDir.getAbsolutePath());
            }
            if (!logDir.canWrite()) {
                Log.w(LogDomain.DATABASE, logDir.getAbsolutePath() + " is not writable");
            }
            this.directory = logDirPath;
            return this;
        }

        @NonNull
        public LogLevel getLevel() {
            return this.level;
        }

        @NonNull
        public Builder setLevel(@NonNull LogLevel level) {
            this.level = Preconditions.assertNotNull(level, "log level");
            return this;
        }

        public int getMaxKeptFiles() {
            return this.maxKeptFiles;
        }

        @NonNull
        public Builder setMaxKeptFiles(int maxKeptFiles) {
            this.maxKeptFiles = Preconditions.assertNotNegative(maxKeptFiles, "max kept files");
            return this;
        }

        public long getMaxFileSize() {
            return this.maxFileSize;
        }

        @NonNull
        public Builder setMaxFileSize(long maxFileSize) {
            this.maxFileSize = Preconditions.assertNotNegative(maxFileSize, "max file size");
            return this;
        }

        public boolean isPlainText() {
            return this.plainText;
        }

        @NonNull
        public Builder setPlainText(boolean plainText) {
            this.plainText = plainText;
            return this;
        }

        @NonNull
        public FileLogSink build() {
            return new FileLogSink(this);
        }

        @NonNull
        public String toString() {
            return "FileLogger.Builder{" + this.directory + ", " + (Object)((Object)this.level) + ", " + this.maxFileSize + ", " + this.maxKeptFiles + "}";
        }
    }
}

