/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.http.query;

import com.couchbase.mock.JsonUtils;
import com.couchbase.mock.httpio.HandlerUtil;
import com.couchbase.mock.util.Base64;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;

public class QueryServer
implements HttpRequestHandler {
    private static volatile int randNumber = new Random().nextInt();

    public static void resetIndexState() {
        randNumber = new Random().nextInt();
    }

    static void doError(HttpResponse response, String msg, int code) {
        HashMap mm = new HashMap();
        ArrayList ll = new ArrayList();
        HashMap<String, Object> err = new HashMap<String, Object>();
        err.put("msg", msg);
        err.put("code", code);
        ll.add(err);
        mm.put("errors", ll);
        String json = JsonUtils.encode(mm);
        HandlerUtil.makeJsonResponse(response, json);
    }

    private static Map<String, Object> resultMeta() {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("status", "success");
        payload.put("results", new ArrayList());
        return payload;
    }

    private static void addResult(Map<String, Object> meta, Map<String, Object> row) {
        List results = (List)meta.get("results");
        results.add(row);
    }

    private static Map<String, Object> okRow() {
        HashMap<String, Object> mm = new HashMap<String, Object>();
        mm.put("row", "value");
        return mm;
    }

    private void handleString(String query, HttpResponse response) {
        Map<String, Object> result;
        if ((query = query.toLowerCase()).startsWith("prepare")) {
            if (!query.equals("prepare select mockrow")) {
                QueryServer.doError(response, "keyspace not found", 12003);
                return;
            }
            HashMap<String, Object> mm = new HashMap<String, Object>();
            mm.put("randomNumber", randNumber);
            String encoded = Base64.encode(JsonUtils.encode(mm));
            mm.put("encoded_plan", encoded);
            mm.put("name", "blah-blah-" + new Random().nextLong());
            result = mm;
        } else if (query.equals("select mockrow")) {
            result = QueryServer.okRow();
        } else if (query.equals("select emptyrow")) {
            result = null;
        } else {
            QueryServer.doError(response, "keyspace not found", 12003);
            return;
        }
        Map<String, Object> payload = QueryServer.resultMeta();
        if (result != null) {
            QueryServer.addResult(payload, result);
        }
        String resStr = JsonUtils.encode(payload);
        HandlerUtil.makeJsonResponse(response, resStr);
    }

    private void handlePrepared(Map<String, Object> body, HttpResponse response) {
        String name = (String)body.get("prepared");
        String encoded = (String)body.get("encoded_plan");
        if (name == null || encoded == null) {
            System.err.println(body.toString());
            QueryServer.doError(response, "missing field", 4040);
            return;
        }
        String decoded = Base64.decode(encoded);
        if (decoded.isEmpty()) {
            QueryServer.doError(response, "could not decode base64", 4070);
            return;
        }
        Map<String, Object> mm = JsonUtils.decodeAsMap(decoded);
        int randNum = ((Number)mm.get("randomNumber")).intValue();
        if (randNum == randNumber) {
            Map<String, Object> payload = QueryServer.resultMeta();
            QueryServer.addResult(payload, QueryServer.okRow());
            String resStr = JsonUtils.encode(payload);
            HandlerUtil.makeJsonResponse(response, resStr);
        } else {
            QueryServer.doError(response, "index deleted or node hosting the index is down - cause: queryport.indexNotFound", 5000);
        }
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        Map<String, Object> mm;
        if (!request.getRequestLine().getMethod().equals("POST")) {
            response.setStatusCode(405);
            return;
        }
        HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
        String txt = EntityUtils.toString(entity);
        try {
            mm = JsonUtils.decodeAsMap(txt);
            if (mm == null) {
                throw new RuntimeException("Body is empty: " + txt);
            }
        }
        catch (Exception ex) {
            HandlerUtil.make400Response(response, ex.toString());
            return;
        }
        if (!mm.containsKey("statement")) {
            this.handlePrepared(mm, response);
        } else {
            this.handleString((String)mm.get("statement"), response);
        }
    }
}

