/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached;

import com.couchbase.mock.memcached.CommandExecutor;
import com.couchbase.mock.memcached.MemcachedConnection;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinaryGetErrmapCommand;
import com.couchbase.mock.memcached.protocol.BinaryGetErrmapResponse;
import com.couchbase.mock.memcached.protocol.BinaryResponse;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import com.couchbase.mock.util.ReaderUtils;
import java.io.IOException;

public class GetErrmapCommandExecutor
implements CommandExecutor {
    private static final String ERRMAP_V1;

    @Override
    public void execute(BinaryCommand cmdBase, MemcachedServer server, MemcachedConnection client) {
        BinaryGetErrmapCommand cmd = (BinaryGetErrmapCommand)cmdBase;
        short version = cmd.getVersion();
        if (version < 1) {
            client.sendResponse(new BinaryResponse(cmd, ErrorCode.KEY_ENOENT));
        } else {
            client.sendResponse(new BinaryGetErrmapResponse((BinaryCommand)cmd, ERRMAP_V1));
        }
    }

    static {
        try {
            ERRMAP_V1 = ReaderUtils.fromResource("errmap/errmap_v1.json");
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't load error map!", e);
        }
    }
}

