/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached;

import com.couchbase.mock.memcached.BinaryProtocolHandler;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.MutationInfoWriter;
import com.couchbase.mock.memcached.OutputContext;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinaryHelloCommand;
import com.couchbase.mock.memcached.protocol.BinaryResponse;
import com.couchbase.mock.memcached.protocol.CommandFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class MemcachedConnection {
    private final BinaryProtocolHandler protocolHandler;
    private final byte[] header;
    private BinaryCommand command;
    private final ByteBuffer input;
    private List<ByteBuffer> pending = new LinkedList<ByteBuffer>();
    private boolean authenticated;
    private boolean closed = false;
    private final MutationInfoWriter miw = new MutationInfoWriter();
    private boolean[] supportedFeatures = new boolean[BinaryHelloCommand.Feature.MAX.getValue()];

    public MemcachedConnection(MemcachedServer server) {
        this.authenticated = server.getBucket().getPassword().length() <= 0;
        this.header = new byte[24];
        this.input = ByteBuffer.wrap(this.header);
        this.protocolHandler = server.getProtocolHandler();
    }

    public void step() throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        if (this.input.position() == this.header.length) {
            if (this.command == null) {
                this.command = CommandFactory.create(this.input);
            }
            if (this.command.complete()) {
                this.command.process();
                this.protocolHandler.execute(this.command, this);
                this.command = null;
                this.input.rewind();
            }
        }
    }

    public synchronized void sendResponse(BinaryResponse response) {
        if (this.pending == null) {
            this.pending = new LinkedList<ByteBuffer>();
        }
        this.pending.add(response.getBuffer());
    }

    boolean hasOutput() {
        if (this.pending == null) {
            return false;
        }
        if (this.pending.isEmpty()) {
            return false;
        }
        return this.pending.get(0).hasRemaining();
    }

    public ByteBuffer getInputBuffer() {
        if (this.command == null) {
            return this.input;
        }
        return this.command.getInputBuffer();
    }

    public OutputContext borrowOutputContext() {
        if (!this.hasOutput()) {
            return null;
        }
        OutputContext ctx = new OutputContext(this.pending);
        this.pending = null;
        return ctx;
    }

    public void returnOutputContext(OutputContext ctx) {
        List<ByteBuffer> remaining = ctx.releaseRemaining();
        if (this.pending == null) {
            this.pending = remaining;
        } else {
            List<ByteBuffer> tmp = this.pending;
            this.pending = remaining;
            this.pending.addAll(tmp);
        }
    }

    void shutdown() {
        this.closed = true;
    }

    void setAuthenticated() {
        this.authenticated = true;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public MutationInfoWriter getMutinfoWriter() {
        return this.miw;
    }

    public boolean supportsXerror() {
        return this.supportedFeatures[BinaryHelloCommand.Feature.XERROR.getValue()];
    }

    public boolean[] getSupportedFeatures() {
        return Arrays.copyOf(this.supportedFeatures, this.supportedFeatures.length);
    }

    void setSupportedFeatures(boolean[] input) {
        if (input.length != this.supportedFeatures.length) {
            throw new IllegalArgumentException("Bad features length!");
        }
        block3: for (int i = 0; i < input.length; ++i) {
            BinaryHelloCommand.Feature feature = BinaryHelloCommand.Feature.valueOf(i);
            if (feature == null) {
                this.supportedFeatures[i] = false;
                continue;
            }
            switch (feature) {
                case MUTATION_SEQNO: 
                case XERROR: 
                case XATTR: 
                case SELECT_BUCKET: {
                    this.supportedFeatures[i] = input[i];
                    continue block3;
                }
                default: {
                    this.supportedFeatures[i] = false;
                }
            }
        }
        if (this.supportedFeatures[BinaryHelloCommand.Feature.MUTATION_SEQNO.getValue()]) {
            this.miw.setEnabled(true);
        } else {
            this.miw.setEnabled(false);
        }
    }
}

