/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached;

import com.couchbase.mock.Bucket;
import com.couchbase.mock.memcached.CommandExecutor;
import com.couchbase.mock.memcached.MemcachedConnection;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinarySaslResponse;
import com.couchbase.mock.memcached.protocol.CommandCode;

public class SaslCommandExecutor
implements CommandExecutor {
    @Override
    public void execute(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) {
        CommandCode cc = cmd.getComCode();
        switch (cc) {
            case SASL_LIST_MECHS: {
                client.sendResponse(new BinarySaslResponse(cmd, "PLAIN"));
                break;
            }
            case SASL_AUTH: {
                byte[] raw = cmd.getValue();
                String[] strs = new String[3];
                int offset = 0;
                int oix = 0;
                for (int ii = 0; ii < raw.length; ++ii) {
                    if (raw[ii] != 0) continue;
                    strs[oix++] = new String(raw, offset, ii - offset);
                    offset = ii + 1;
                }
                strs[oix] = new String(raw, offset, raw.length - offset);
                String user = strs[1];
                String pass = strs[2];
                Bucket bucket = server.getBucket();
                if (!bucket.getName().equals(user)) {
                    client.sendResponse(new BinarySaslResponse(cmd));
                    break;
                }
                String bPass = bucket.getPassword();
                if (bPass.isEmpty() || bPass.equals(pass)) {
                    client.sendResponse(new BinarySaslResponse(cmd, "Authenticated"));
                    client.setAuthenticated();
                    break;
                }
                client.sendResponse(new BinarySaslResponse(cmd));
                break;
            }
            case SASL_STEP: {
                client.sendResponse(new BinarySaslResponse(cmd));
                break;
            }
            default: {
                client.sendResponse(new BinarySaslResponse(cmd));
            }
        }
    }
}

