/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached;

import com.couchbase.mock.memcached.CommandExecutor;
import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.memcached.MemcachedConnection;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.MutationInfoWriter;
import com.couchbase.mock.memcached.MutationStatus;
import com.couchbase.mock.memcached.SubdocCommandExecutor;
import com.couchbase.mock.memcached.VBucketStore;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinaryResponse;
import com.couchbase.mock.memcached.protocol.BinarySubdocMultiCommand;
import com.couchbase.mock.memcached.protocol.BinarySubdocMultiMutationCommand;
import com.couchbase.mock.memcached.protocol.CommandCode;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import com.couchbase.mock.subdoc.Operation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class SubdocMultiCommandExecutor
implements CommandExecutor {
    @Override
    public void execute(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) {
        ExecutorContext cx;
        VBucketStore cache = server.getCache(cmd);
        Item existing = cache.get(cmd.getKeySpec());
        if (existing == null) {
            if (!(cmd instanceof BinarySubdocMultiMutationCommand)) {
                client.sendResponse(new BinaryResponse(cmd, ErrorCode.KEY_ENOENT));
                return;
            }
            BinarySubdocMultiMutationCommand mcmd = (BinarySubdocMultiMutationCommand)cmd;
            if ((mcmd.getSubdocDocFlags() & 3) == 0) {
                client.sendResponse(new BinaryResponse(cmd, ErrorCode.KEY_ENOENT));
                return;
            }
            String rootString = mcmd.getRootType();
            if (rootString == null) {
                client.sendResponse(new BinaryResponse(cmd, ErrorCode.KEY_ENOENT));
                return;
            }
            Item newItem = new Item(cmd.getKeySpec(), 0, 0, rootString.getBytes(), "{}".getBytes(), 0L);
            cx = new ExecutorContext(cmd, client, newItem, cache, true);
        } else {
            if (cmd instanceof BinarySubdocMultiMutationCommand && (((BinarySubdocMultiMutationCommand)cmd).getSubdocDocFlags() & 2) != 0) {
                client.sendResponse(new BinaryResponse(cmd, ErrorCode.KEY_EEXISTS));
                return;
            }
            cx = new ExecutorContext(cmd, client, existing, cache, false);
        }
        cx.execute();
    }

    static class ExecutorContext {
        final List<SpecResult> results;
        final List<BinarySubdocMultiCommand.MultiSpec> specs;
        final BinarySubdocMultiCommand command;
        final MemcachedConnection client;
        final Item existing;
        final VBucketStore cache;
        boolean hasXattrSpec;
        boolean needCreate;
        String currentDoc;
        String currentAttrs;

        boolean isMutator() {
            return this.command.getComCode() == CommandCode.SUBDOC_MULTI_MUTATION;
        }

        ExecutorContext(BinaryCommand cmd, MemcachedConnection client, Item existing, VBucketStore cache, boolean needCreate) {
            this.existing = existing;
            this.currentDoc = new String(existing.getValue());
            this.currentAttrs = new String(existing.getXattr() == null ? "{}".getBytes() : existing.getXattr());
            this.command = (BinarySubdocMultiCommand)cmd;
            this.client = client;
            this.specs = this.command.getLookupSpecs();
            this.cache = cache;
            this.needCreate = needCreate;
            this.hasXattrSpec = false;
            this.results = new ArrayList<SpecResult>();
        }

        private boolean handleLookupSpec(BinarySubdocMultiCommand.MultiSpec spec, int index) {
            Operation op = spec.getOp();
            if (op == null) {
                this.results.add(new SpecResult(index, ErrorCode.UNKNOWN_COMMAND));
                return true;
            }
            if (!op.isLookup()) {
                this.client.sendResponse(new BinaryResponse(this.command, ErrorCode.SUBDOC_INVALID_COMBO));
                return false;
            }
            boolean isXattr = (spec.getFlags() & 4) != 0;
            SubdocCommandExecutor.ResultInfo rsi = SubdocCommandExecutor.executeSubdocLookup(op, isXattr ? this.currentAttrs : this.currentDoc, spec.getPath());
            switch (rsi.getStatus()) {
                case SUCCESS: {
                    if (op.returnsMatch()) {
                        this.results.add(new SpecResult(index, rsi.getMatchString()));
                    } else {
                        this.results.add(new SpecResult(index, ErrorCode.SUCCESS));
                    }
                    return true;
                }
                case SUBDOC_DOC_NOTJSON: 
                case SUBDOC_DOC_E2DEEP: {
                    this.client.sendResponse(new BinaryResponse(this.command, rsi.getStatus()));
                    return false;
                }
            }
            this.results.add(new SpecResult(index, rsi.getStatus()));
            return true;
        }

        private boolean sendMutationError(ErrorCode ec, int index) {
            ByteBuffer bb = ByteBuffer.allocate(3);
            bb.put((byte)index);
            bb.putShort(ec.value());
            ErrorCode topLevelRc = ec == ErrorCode.SUBDOC_INVALID_COMBO ? ec : ErrorCode.SUBDOC_MULTI_FAILURE;
            BinaryResponse br = BinaryResponse.createWithValue(topLevelRc, this.command, bb.array(), 0L);
            this.client.sendResponse(br);
            return false;
        }

        private SubdocCommandExecutor.ResultInfo handleMutationSpecInner(Operation op, String input, BinarySubdocMultiCommand.MultiSpec spec) throws MutationError {
            SubdocCommandExecutor.ResultInfo rsi;
            byte specFlags = spec.getFlags();
            if ((this.command.getSubdocDocFlags() & 3) != 0) {
                specFlags = (byte)(specFlags | 1);
            }
            if ((rsi = SubdocCommandExecutor.executeSubdocOperation(op, input, spec.getPath(), spec.getValue(), specFlags)).getStatus() != ErrorCode.SUCCESS) {
                throw new MutationError(rsi.getStatus());
            }
            return rsi;
        }

        private boolean handleMutationSpec(BinarySubdocMultiCommand.MultiSpec spec, int index) {
            SubdocCommandExecutor.ResultInfo rsi;
            Operation op = spec.getOp();
            if (op == null) {
                return this.sendMutationError(ErrorCode.UNKNOWN_COMMAND, index);
            }
            if (!op.isMutator()) {
                return this.sendMutationError(ErrorCode.SUBDOC_INVALID_COMBO, index);
            }
            boolean isXattr = (spec.getFlags() & 4) != 0;
            try {
                if (isXattr) {
                    rsi = this.handleMutationSpecInner(op, this.currentAttrs, spec);
                    this.currentAttrs = rsi.getNewDocString();
                    this.hasXattrSpec = true;
                } else {
                    rsi = this.handleMutationSpecInner(op, this.currentDoc, spec);
                    this.currentDoc = rsi.getNewDocString();
                }
            }
            catch (MutationError ex) {
                return this.sendMutationError(ex.code, index);
            }
            if (op.returnsMatch()) {
                this.results.add(new SpecResult(index, rsi.getMatchString()));
            }
            return true;
        }

        void execute() {
            for (int i = 0; i < this.specs.size(); ++i) {
                BinarySubdocMultiCommand.MultiSpec spec = this.specs.get(i);
                boolean result = this.isMutator() ? this.handleMutationSpec(spec, i) : this.handleLookupSpec(spec, i);
                if (result) continue;
                return;
            }
            if (this.isMutator()) {
                MutationStatus ms;
                MutationInfoWriter miw = this.client.getMutinfoWriter();
                Object newXattrs = this.hasXattrSpec ? this.currentAttrs.getBytes() : (Object)(this.needCreate ? null : this.existing.getXattr());
                Item newItem = new Item(this.existing.getKeySpec(), this.existing.getFlags(), this.command.getNewExpiry(this.existing.getExpiryTime()), this.currentDoc.getBytes(), (byte[])newXattrs, this.command.getCas());
                if (this.needCreate) {
                    this.needCreate = false;
                    ms = this.cache.add(newItem, this.client.supportsXerror());
                    if (ms.getStatus() == ErrorCode.KEY_EEXISTS) {
                        this.results.clear();
                        this.execute();
                        return;
                    }
                } else {
                    ms = this.cache.replace(newItem, this.client.supportsXerror());
                }
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                for (SpecResult result : this.results) {
                    int specLen = 3;
                    if (result.ec == ErrorCode.SUCCESS) {
                        specLen += 4;
                        specLen += result.value.length();
                    }
                    ByteBuffer bb = ByteBuffer.allocate(specLen);
                    bb.put((byte)result.index);
                    bb.putShort(result.ec.value());
                    if (result.ec == ErrorCode.SUCCESS) {
                        bb.putInt(result.value.length());
                        bb.put(result.value.getBytes());
                    }
                    try {
                        bao.write(bb.array());
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                this.client.sendResponse(new BinaryResponse(this.command, ms, miw, newItem.getCas(), bao.toByteArray()));
            } else {
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                boolean hasError = false;
                for (SpecResult result : this.results) {
                    String value = result.value;
                    if (value == null) {
                        value = "";
                    }
                    ByteBuffer bb = ByteBuffer.allocate(6 + value.length());
                    bb.putShort(result.ec.value());
                    bb.putInt(value.length());
                    bb.put(value.getBytes());
                    if (result.ec != ErrorCode.SUCCESS) {
                        hasError = true;
                    }
                    try {
                        bao.write(bb.array());
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                byte[] multiPayload = bao.toByteArray();
                ErrorCode finalEc = hasError ? ErrorCode.SUBDOC_MULTI_FAILURE : ErrorCode.SUCCESS;
                BinaryResponse resp = BinaryResponse.createWithValue(finalEc, this.command, multiPayload, this.existing.getCas());
                this.client.sendResponse(resp);
            }
        }

        private class MutationError
        extends Exception {
            ErrorCode code;

            MutationError(ErrorCode ec) {
                this.code = ec;
            }
        }
    }

    static class SpecResult {
        final int index;
        final ErrorCode ec;
        final String value;

        SpecResult(int index, ErrorCode ec) {
            this.index = index;
            this.ec = ec;
            this.value = null;
        }

        SpecResult(int index, String value) {
            this.index = index;
            this.value = value;
            this.ec = ErrorCode.SUCCESS;
        }
    }
}

