/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.protocol;

import com.couchbase.mock.memcached.VBucketCoordinates;
import com.couchbase.mock.memcached.protocol.BinaryObserveSeqnoCommand;
import com.couchbase.mock.memcached.protocol.BinaryResponse;
import com.couchbase.mock.memcached.protocol.ErrorCode;

public class BinaryObserveSeqnoResponse
extends BinaryResponse {
    static final int REPLY_LENGTH_NORMAL = 27;
    static final int REPLY_LENGTH_FAILOVER = 43;
    static final int COMMON_OFFSET = 25;

    private void writeInfoCommon(short vbid, long uuid, long seqCache, long seqDisk) {
        this.buffer.position(25);
        this.buffer.putShort(vbid);
        this.buffer.putLong(uuid);
        this.buffer.putLong(seqDisk);
        this.buffer.putLong(seqCache);
    }

    public BinaryObserveSeqnoResponse(BinaryObserveSeqnoCommand cmd, long seqCache, long seqDisk) {
        super(cmd, ErrorCode.SUCCESS, 0, 0, 27, 0L);
        this.buffer.put(24, (byte)0);
        this.writeInfoCommon(cmd.getVBucketId(), cmd.getUuid(), seqCache, seqDisk);
        this.buffer.rewind();
    }

    public BinaryObserveSeqnoResponse(BinaryObserveSeqnoCommand cmd, VBucketCoordinates coordCur, VBucketCoordinates coordOld, long seqDisk) {
        super(cmd, ErrorCode.SUCCESS, 0, 0, 43, 0L);
        this.buffer.put(24, (byte)1);
        this.writeInfoCommon(cmd.getVBucketId(), coordCur.getUuid(), coordCur.getSeqno(), seqDisk);
        this.buffer.putLong(coordOld.getUuid());
        this.buffer.putLong(coordOld.getSeqno());
        this.buffer.rewind();
    }
}

