/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.protocol;

import com.couchbase.mock.memcached.MutationInfoWriter;
import com.couchbase.mock.memcached.MutationStatus;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;

public class BinaryResponse {
    private static final byte MAGIC = -127;
    private static final byte DATA_TYPE = 0;
    private static final byte DATA_TYPE_JSON = 1;
    final ByteBuffer buffer;

    BinaryResponse(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    BinaryResponse(BinaryCommand command, ErrorCode errorCode, int extraLength, int keyLength, int dataLength, long cas) {
        this.buffer = BinaryResponse.createAndRewind(command, errorCode, extraLength, keyLength, dataLength, cas);
    }

    public BinaryResponse(BinaryCommand command, ErrorCode errorCode, String errorContext) {
        if (command.getEventId() != null || errorContext != null) {
            JsonObject error = new JsonObject();
            if (command.getEventId() != null) {
                error.addProperty("ref", command.getEventId());
            }
            if (errorContext != null) {
                error.addProperty("context", errorContext);
            }
            JsonObject body = new JsonObject();
            body.add("error", error);
            byte[] value = new Gson().toJson(body).getBytes();
            this.buffer = BinaryResponse.create(command, errorCode, 0, 0, value.length, 0L);
            this.buffer.position(5);
            this.buffer.put((byte)1);
            this.buffer.position(24);
            this.buffer.put(value);
            this.buffer.rewind();
        } else {
            this.buffer = BinaryResponse.createAndRewind(command, errorCode, 0, 0, 0, 0L);
        }
    }

    public BinaryResponse(BinaryCommand command, ErrorCode errorCode) {
        this(command, errorCode, null);
    }

    public BinaryResponse(BinaryCommand command, MutationStatus ms, MutationInfoWriter miw, long cas) {
        this(command, ms, miw, cas, null);
    }

    public static BinaryResponse createWithValue(BinaryCommand command, byte[] value, long cas) {
        return BinaryResponse.createWithValue(ErrorCode.SUCCESS, command, value, cas);
    }

    public static BinaryResponse createWithValue(ErrorCode ec, BinaryCommand command, byte[] value, long cas) {
        int vallen = value == null ? 0 : value.length;
        BinaryResponse resp = new BinaryResponse(command, ec, 0, 0, vallen, cas);
        if (vallen > 0) {
            resp.buffer.position(24);
            resp.buffer.put(value);
        }
        resp.buffer.rewind();
        return resp;
    }

    public BinaryResponse(BinaryCommand command, MutationStatus ms, MutationInfoWriter miw, long cas, byte[] value) {
        short extlen = 0;
        int valLen = 0;
        if (value != null) {
            valLen = value.length;
        }
        boolean shouldWrite = false;
        if (ms.getStatus().value() == ErrorCode.SUCCESS.value()) {
            extlen = miw.extrasLength();
            shouldWrite = true;
        }
        this.buffer = BinaryResponse.createAndRewind(command, ms.getStatus(), extlen, 0, valLen, cas);
        this.buffer.position(24);
        if (shouldWrite && extlen != 0) {
            miw.write(this.buffer, ms.getCoords());
        }
        if (value != null) {
            this.buffer.position(extlen + 24);
            this.buffer.put(value);
        }
        this.buffer.rewind();
    }

    private static ByteBuffer createAndRewind(BinaryCommand command, ErrorCode errorCode, int extraLength, int keyLength, int dataLength, long cas) {
        ByteBuffer message = BinaryResponse.create(command, errorCode, extraLength, keyLength, dataLength, cas);
        message.rewind();
        return message;
    }

    static ByteBuffer create(BinaryCommand command, ErrorCode errorCode, int extraLength, int keyLength, int dataLength, long cas) {
        ByteBuffer message = ByteBuffer.allocate(24 + extraLength + keyLength + dataLength);
        message.put((byte)-127);
        message.put(command.getOpcode());
        message.putShort((short)keyLength);
        message.put((byte)extraLength);
        message.put((byte)0);
        message.putShort(errorCode.value());
        message.putInt(dataLength + keyLength + extraLength);
        message.putInt(command.getOpaque());
        message.putLong(cas);
        return message;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }
}

