/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.control;

import com.couchbase.mock.CouchbaseMock;
import com.couchbase.mock.control.CommandStatus;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class MockCommand {
    @NotNull
    protected CommandStatus getResponse() {
        return new CommandStatus();
    }

    @NotNull
    public abstract CommandStatus execute(@NotNull CouchbaseMock var1, @NotNull Command var2, @NotNull JsonObject var3);

    public static void loadServers(@NotNull JsonObject payload, Set<Integer> enabledServers) {
        if (payload.has("servers")) {
            JsonArray arr = payload.get("servers").getAsJsonArray();
            for (int ii = 0; ii < arr.size(); ++ii) {
                JsonElement e = arr.get(ii);
                enabledServers.add(e.getAsInt());
            }
        }
    }

    public static enum Command {
        FAILOVER,
        RESPAWN,
        HICCUP,
        TRUNCATE,
        MOCKINFO,
        PERSIST,
        CACHE,
        UNPERSIST,
        UNCACHE,
        ENDURE,
        PURGE,
        KEYINFO,
        TIME_TRAVEL,
        HELP,
        OPFAIL,
        SET_CCCP,
        GET_MCPORTS,
        REGEN_VBCOORDS,
        RESET_QUERYSTATE,
        START_CMDLOG,
        STOP_CMDLOG,
        GET_CMDLOG,
        START_RETRY_VERIFY,
        CHECK_RETRY_VERIFY,
        SET_ENHANCED_ERRORS,
        SET_QUERY_ERROR_STATE,
        SET_COMPRESSION;

    }
}

