/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached;

import com.couchbase.mock.Info;
import com.couchbase.mock.memcached.CommandExecutor;
import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.memcached.MemcachedConnection;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.MutationStatus;
import com.couchbase.mock.memcached.VBucketStore;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinaryResponse;
import com.couchbase.mock.memcached.protocol.BinaryStoreCommand;
import com.couchbase.mock.memcached.protocol.BinaryStoreResponse;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import java.net.ProtocolException;

class AppendPrependCommandExecutor
implements CommandExecutor {
    AppendPrependCommandExecutor() {
    }

    @Override
    public void execute(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) throws ProtocolException {
        MutationStatus ms;
        BinaryStoreCommand command = (BinaryStoreCommand)cmd;
        VBucketStore cache = server.getStorage().getCache(server, cmd.getVBucketId());
        Item existing = cache.get(command.getKeySpec());
        if (existing != null && existing.getValue().length + command.getItem(client.snappyMode()).getValue().length > Info.itemSizeMax()) {
            client.sendResponse(new BinaryResponse(cmd, ErrorCode.E2BIG));
            return;
        }
        switch (cmd.getComCode()) {
            case APPEND: 
            case APPENDQ: {
                ms = cache.append(command.getItem(client.snappyMode()), client.supportsXerror());
                break;
            }
            case PREPEND: 
            case PREPENDQ: {
                ms = cache.prepend(command.getItem(client.snappyMode()), client.supportsXerror());
                break;
            }
            default: {
                return;
            }
        }
        if (ms.getStatus() == ErrorCode.SUCCESS) {
            switch (cmd.getComCode()) {
                case APPEND: 
                case PREPEND: {
                    client.sendResponse(new BinaryStoreResponse(command, ms, client.getMutinfoWriter(), existing.getCas()));
                }
            }
        } else {
            ErrorCode err = ms.getStatus();
            if (err == ErrorCode.KEY_ENOENT) {
                err = ErrorCode.NOT_STORED;
            }
            client.sendResponse(new BinaryResponse(cmd, err));
        }
    }
}

