/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached;

import com.couchbase.mock.memcached.CommandExecutor;
import com.couchbase.mock.memcached.MemcachedConnection;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.MutationStatus;
import com.couchbase.mock.memcached.VBucketStore;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinaryResponse;
import com.couchbase.mock.memcached.protocol.CommandCode;
import com.couchbase.mock.memcached.protocol.ErrorCode;

public class DeleteCommandExecutor
implements CommandExecutor {
    @Override
    public void execute(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) {
        VBucketStore cache = server.getStorage().getCache(server, cmd.getVBucketId());
        MutationStatus ms = cache.delete(cmd.getKeySpec(), cmd.getCas(), client.supportsXerror());
        ErrorCode err = ms.getStatus();
        if (cmd.getComCode() != CommandCode.DELETEQ || err != ErrorCode.SUCCESS) {
            client.sendResponse(new BinaryResponse(cmd, ms, client.getMutinfoWriter(), 0L));
        }
    }
}

