/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached;

import com.couchbase.mock.Info;
import com.couchbase.mock.memcached.KeySpec;
import com.couchbase.mock.memcached.VBucketStore;
import com.couchbase.mock.memcached.protocol.Datatype;
import com.couchbase.mock.util.Base64;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Date;

public class Item {
    private final KeySpec keySpec;
    private final int flags;
    private int expiryTime;
    private byte[] xattr;
    private byte[] value;
    private String cached_UTF8 = null;
    private String cached_B64 = null;
    private long cas;
    private byte datatype;
    private long modificationTime;
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private int lockExpiryTime;

    public Item(KeySpec ks, int flags, int expiryTime, byte[] value, byte[] xattr, long cas, byte datatype) {
        this.keySpec = ks;
        this.flags = flags;
        this.value = value;
        this.xattr = xattr;
        this.cas = cas;
        this.expiryTime = VBucketStore.convertExpiryTime(expiryTime);
        this.datatype = datatype;
    }

    public Item(KeySpec ks) {
        this(ks, -1, -1, null, null, -1L, Datatype.RAW.value());
    }

    public Item(Item src) {
        this.keySpec = src.keySpec;
        this.flags = src.flags;
        this.expiryTime = src.expiryTime;
        this.value = src.value;
        this.cas = src.cas;
        this.modificationTime = src.modificationTime;
        this.lockExpiryTime = src.lockExpiryTime;
        this.cached_B64 = src.cached_B64;
        this.cached_UTF8 = src.cached_UTF8;
        this.xattr = src.xattr;
        this.datatype = src.datatype;
    }

    public int getExpiryTime() {
        return this.expiryTime;
    }

    public long getExpiryTimeInMillis() {
        return (long)this.expiryTime * 1000L;
    }

    public void setExpiryTime(int e) {
        this.expiryTime = VBucketStore.convertExpiryTime(e);
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public byte getDatatype() {
        return this.datatype;
    }

    public int getFlags() {
        return this.flags;
    }

    public KeySpec getKeySpec() {
        return this.keySpec;
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte[] getXattr() {
        return this.xattr;
    }

    public String getUtf8() throws CharacterCodingException {
        if (this.cached_UTF8 != null) {
            return this.cached_UTF8;
        }
        CharsetDecoder dec = UTF8_CHARSET.newDecoder();
        this.cached_UTF8 = dec.decode(ByteBuffer.wrap(this.value)).toString();
        return this.cached_UTF8;
    }

    public String getBase64() {
        if (this.cached_B64 != null) {
            return this.cached_B64;
        }
        this.cached_B64 = Base64.encode(this.value);
        return this.cached_B64;
    }

    public long getCas() {
        if (this.isLocked()) {
            return -1L;
        }
        return this.cas;
    }

    public long getCasReal() {
        return this.cas;
    }

    void setCas(long l) {
        this.modificationTime = new Date().getTime();
        this.cas = l;
    }

    void setLockExpiryTime(int e) {
        this.lockExpiryTime = VBucketStore.convertExpiryTime(e);
    }

    int getLockExpiryTime() {
        return this.lockExpiryTime;
    }

    public boolean isLocked() {
        if (this.lockExpiryTime == 0) {
            return false;
        }
        long now = new Date().getTime() / 1000L + Info.getClockOffset();
        return now <= (long)this.lockExpiryTime;
    }

    public boolean ensureUnlocked(long cas) {
        if (cas == this.cas) {
            this.lockExpiryTime = 0;
            return true;
        }
        return !this.isLocked();
    }

    public void append(Item i) {
        byte[] s1 = this.value;
        byte[] s2 = i.getValue();
        byte[] dst = new byte[s1.length + s2.length];
        System.arraycopy(s1, 0, dst, 0, s1.length);
        System.arraycopy(s2, 0, dst, s1.length, s2.length);
        this.value = dst;
    }

    public void prepend(Item i) {
        byte[] s1 = this.value;
        byte[] s2 = i.getValue();
        byte[] dst = new byte[s1.length + s2.length];
        System.arraycopy(s2, 0, dst, 0, s2.length);
        System.arraycopy(s1, 0, dst, s2.length, s1.length);
        this.value = dst;
    }
}

