/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock;

import com.couchbase.mock.Bucket;
import com.couchbase.mock.BucketConfiguration;
import com.couchbase.mock.CouchbaseMock;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class MemcachedBucket
extends Bucket {
    public MemcachedBucket(CouchbaseMock cluster, BucketConfiguration config) throws IOException {
        super(cluster, config);
    }

    @Override
    public Map<String, Object> getConfigMap() {
        Map<String, Object> map = this.getCommonConfig();
        map.put("name", this.name);
        map.put("authType", "sasl");
        map.put("bucketType", "memcached");
        map.put("flushCacheUri", "/pools/default/buckets/" + this.name + "/controller/doFlush");
        map.put("nodeLocator", "ketama");
        map.put("proxyPort", 0);
        map.put("replicaNumber", 0);
        map.put("saslPassword", this.getPassword());
        map.put("streamingUri", "/pools/default/bucketsStreaming/" + this.name);
        map.put("uri", "/pools/default/buckets/" + this.name);
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        for (MemcachedServer server : this.activeServers()) {
            nodes.add(server.toNodeConfigInfo());
        }
        map.put("nodes", nodes);
        return map;
    }

    @Override
    public Bucket.BucketType getType() {
        return Bucket.BucketType.MEMCACHED;
    }

    @Override
    public ErrorCode storeItem(String key, byte[] value) {
        throw new UnsupportedOperationException("Storing items not yet supported for memcached buckets!");
    }
}

