/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.client;

import com.couchbase.mock.client.AbstractMockClient;
import com.couchbase.mock.client.MockRequest;
import com.couchbase.mock.client.MockResponse;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MockHttpClient
extends AbstractMockClient {
    private final InetSocketAddress restAddress;

    public MockHttpClient(@NotNull InetSocketAddress restAddress) {
        if (restAddress == null) {
            MockHttpClient.$$$reportNull$$$0(0);
        }
        this.restAddress = restAddress;
    }

    private URL buildRequestUri(MockRequest request) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("http://").append(this.restAddress.getHostName()).append(":").append(this.restAddress.getPort()).append("/mock/").append(URLEncoder.encode(request.getName(), "UTF-8")).append("?");
        this.appendPayload(sb, request.getPayload());
        return new URL(sb.toString());
    }

    private void appendPayload(StringBuilder sb, Map<String, Object> payload) throws UnsupportedEncodingException {
        Gson gson = new Gson();
        for (Map.Entry<String, Object> kv : payload.entrySet()) {
            String jStr = gson.toJson(kv.getValue());
            jStr = URLEncoder.encode(jStr, "UTF-8");
            sb.append(kv.getKey()).append('=').append(jStr).append('&');
        }
        int index = sb.lastIndexOf("&");
        if (index > 0) {
            sb.deleteCharAt(index);
        }
    }

    @Override
    @NotNull
    public MockResponse request(@NotNull MockRequest request) throws IOException {
        if (request == null) {
            MockHttpClient.$$$reportNull$$$0(1);
        }
        URL url = this.buildRequestUri(request);
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        uc.connect();
        MockResponse mockResponse = new MockResponse(this.readResponse(uc.getInputStream()));
        if (mockResponse == null) {
            MockHttpClient.$$$reportNull$$$0(2);
        }
        return mockResponse;
    }

    private String readResponse(@NotNull InputStream input) throws IOException {
        int nr;
        if (input == null) {
            MockHttpClient.$$$reportNull$$$0(3);
        }
        StringBuilder sb = new StringBuilder();
        byte[] buf = new byte[4096];
        while ((nr = input.read(buf)) != -1) {
            sb.append(new String(buf, 0, nr));
        }
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restAddress";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/couchbase/mock/client/MockHttpClient";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/couchbase/mock/client/MockHttpClient";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "request";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readResponse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

