/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class MockResponse {
    private final JsonObject response;

    public MockResponse(String jsonString) {
        this.response = new Gson().fromJson(jsonString, JsonObject.class);
    }

    public boolean isOk() {
        return this.response.get("status").getAsString().toLowerCase().equals("ok");
    }

    public String getErrorMessage() {
        if (this.response.has("error")) {
            return this.response.get("error").getAsString();
        }
        return "";
    }

    public JsonElement getPayload() {
        return this.response.get("payload");
    }

    public JsonObject getRawJson() {
        return this.response;
    }
}

